#ifndef __MODULE_WIN32DLL_H__
#define __MODULE_WIN32DLL_H__
#include <ascript.h>

AScript_BeginModule(win32dll)

//-----------------------------------------------------------------------------
// Object_Dll declaration
//-----------------------------------------------------------------------------
AScript_DeclarePrivClass(Dll);

class Object_Dll : public Object {
private:
	HMODULE _hModule;
	String _fileName;
public:
	AScript_DeclareObjectAccessor(Dll)
public:
	inline Object_Dll() : Object(AScript_PrivClass(Dll)), _hModule(NULL) {}
	virtual ~Object_Dll();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
	bool Open(Signal sig, const char *fileName);
	void Close();
	inline HMODULE GetModuleHandle() { return _hModule; }
};

//-----------------------------------------------------------------------------
// Function_Proc
//-----------------------------------------------------------------------------
class Function_Proc : public Function {
private:
	Object_Dll *_pObjDll;
	FARPROC _proc;
public:
	inline Function_Proc(Environment &envScope, const Symbol *pSymbol,
													Object_Dll *pObjDll, FARPROC proc) :
		Function(envScope, pSymbol, FUNCTYPE_Function), _pObjDll(pObjDll), _proc(proc) {}
	~Function_Proc();
private:
	virtual Value DoEval(Environment &env, Signal sig, Args &args) const;
};

}}

#endif
