#ifndef __OBJECT_PALETTE_H__
#define __OBJECT_PALETTE_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Palette
//-----------------------------------------------------------------------------
class DLLDECLARE Class_Palette : public Class {
public:
	Class_Palette(Environment *pEnvOuter);
	virtual bool CastFrom(Environment &env, Signal sig, Value &value);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

//-----------------------------------------------------------------------------
// Object_Palette
//-----------------------------------------------------------------------------
class DLLDECLARE Object_Palette : public Object {
public:
#if USE_WINDOWS_DIB
	enum {
		OffsetRed	= 2,
		OffsetGreen	= 1,
		OffsetBlue	= 0,
		OffsetAlpha	= 3,
	};
#else
	enum {
		OffsetRed	= 0,
		OffsetGreen	= 1,
		OffsetBlue	= 2,
		OffsetAlpha	= 3,
	};
#endif
public:
	class IteratorEach : public Iterator {
	private:
		Object_Palette *_pObjPalette;
		size_t _idx;
	public:
		inline IteratorEach(Object_Palette *pObjPalette) :
			Iterator(false), _pObjPalette(pObjPalette), _idx(0) {}
		virtual ~IteratorEach();
		virtual bool DoNext(Signal sig, Value &value);
		virtual String ToString(Signal sig) const;
	};
public:
	inline static Object_Palette *GetSelfObj(Args &args) {
		return dynamic_cast<Object_Palette *>(args.GetSelfObj());
	}
private:
	size_t _nEntries;
	unsigned char *_buff;
	OAL::LargeMemory _largeMem;
	static const unsigned char _rgb_Basic[];
	static const unsigned char _rgb_Win256[];
	static const unsigned char _rgb_WebSafe[];
public:
	inline Object_Palette(Class *pClass) :
						Object(pClass), _nEntries(0), _buff(NULL) {}
	Object_Palette(Environment &env, size_t nEntries = 0);
	Object_Palette(const Object_Palette &obj);
	virtual ~Object_Palette();
	static inline Object_Palette *IncRef(const Object_Palette *pObj) {
		return dynamic_cast<Object_Palette *>(Object::IncRef(pObj));
	}
	virtual Object *Clone() const;
	inline unsigned char *GetBuff() { return _buff; }
	static inline size_t CalcBuffSize(size_t nEntries) { return nEntries * 4; }
	inline size_t GetBuffSize() const { return CalcBuffSize(_nEntries); }
	inline unsigned char *GetEntry(size_t idx) { return _buff + idx * 4; }
	inline const unsigned char *GetEntry(size_t idx) const { return _buff + idx * 4; }
	inline void SetEntry(size_t idx, unsigned char red,
			unsigned char green, unsigned char blue, unsigned char alpha = 255) {
		unsigned char *entry = GetEntry(idx);
		entry[OffsetRed] = red;
		entry[OffsetGreen] = green;
		entry[OffsetBlue] = blue;
		entry[OffsetAlpha] = alpha;
	}
	inline void SetEntry(size_t idx, const Color &c, unsigned char alpha = 255) {
		SetEntry(idx, c.GetRed(), c.GetGreen(), c.GetBlue(), alpha);
	}
	inline size_t CountEntries() const { return _nEntries; }
	void AllocBuff(size_t nEntries);
	void ResizeBuff(size_t nEntries, size_t nEntriesToCopy);
	bool Prepare(Signal sig, const Symbol *pSymbol);
	virtual Iterator *CreateIterator(Signal sig);
	virtual Value IndexGet(Signal sig, const Value &valueIdx);
	virtual void IndexSet(Signal sig, const Value &valueIdx, const Value &value);
	Value GetColorValue(size_t idx);
	void SetColorObj(size_t idx, const Object_Color *pObjColor);
	size_t LookupNearest(unsigned char red, unsigned char green, unsigned char blue) const;
	bool UpdateByImage(const Object_Image *pObjImage, bool shrinkFlag);
	bool UpdateByImage(Signal sig, const Object_Image *pObjImage, bool shrinkFlag);
	bool UpdateByPalette(const Object_Palette *pObjPalette, bool shrinkFlag);
	bool UpdateByPalette(Signal sig, const Object_Palette *pObjPalette, bool shrinkFlag);
	void Shrink(size_t nEntries = 0);
	inline size_t LookupNearest(const unsigned char *pPixel) const {
		return LookupNearest(pPixel[OffsetRed], pPixel[OffsetGreen], pPixel[OffsetBlue]);
	}
	inline size_t LookupNearest(const Color &color) const {
		return LookupNearest(color.GetRed(), color.GetGreen(), color.GetBlue());
	}
	inline size_t LookupNearest(const Object_Color *pObjColor) const {
		return LookupNearest(pObjColor->GetRed(), pObjColor->GetGreen(), pObjColor->GetBlue());
	}
	size_t NextBlankIndex() const;
	size_t NextBlankIndex(ColorSet &colorSet) const;
	virtual String ToString(Signal sig, bool exprFlag);
};

}

#endif
