#ifndef __OBJECT_FILESTAT_H__
#define __OBJECT_FILESTAT_H__

#include "Object.h"
#include "Environment.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_FileStat / Object_FileStat
//-----------------------------------------------------------------------------
class DLLDECLARE Class_FileStat : public Class {
public:
	Class_FileStat(Environment *pEnvOuter);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLDECLARE Object_FileStat : public Object {
public:
	inline static Object_FileStat *GetSelfObj(Args &args) {
		return dynamic_cast<Object_FileStat *>(args.GetSelfObj());
	}
private:
	FileStat _fileStat;
public:
	inline Object_FileStat(Environment &env, const FileStat &fileStat) :
				Object(env.LookupClass(VTYPE_FileStat)), _fileStat(fileStat) {}
	inline Object_FileStat(Class *pClass, const FileStat &fileStat) :
				Object(pClass), _fileStat(fileStat) {}
	Object_FileStat(const Object_FileStat &obj);
	virtual ~Object_FileStat();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
	inline const FileStat &GetFileStat() const { return _fileStat; }
};

}

#endif
