#ifndef __OBJECT_FILE_H__
#define __OBJECT_FILE_H__

#include "Object_Stream.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_File
//-----------------------------------------------------------------------------
class DLLDECLARE Class_File : public Class_Stream {
public:
	Class_File(Environment *pEnvOuter);
	virtual bool CastFrom(Environment &env, Signal sig, Value &value);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

//-----------------------------------------------------------------------------
// Object_File
//-----------------------------------------------------------------------------
class DLLDECLARE Object_File : public Object_Stream {
public:
	inline static Object_File *GetSelfObj(Args &args) {
		return dynamic_cast<Object_File *>(args.GetSelfObj());
	}
public:
	inline Object_File(Environment &env) :
				Object_Stream(env.LookupClass(VTYPE_File), new File()) {}
	inline Object_File(Class *pClass) :
				Object_Stream(pClass, new File()) {}
	virtual ~Object_File();
	virtual Object *Clone() const;
	virtual Iterator *CreateIterator(Signal sig);
	virtual String ToString(Signal sig, bool exprFlag);
	inline File &GetFile() { return *dynamic_cast<File *>(_pStream.get()); }
};

//-----------------------------------------------------------------------------
// StreamFactory_File
//-----------------------------------------------------------------------------
class DLLDECLARE StreamFactory_File : public StreamFactory {
public:
	virtual bool IsResponsible(Signal sig, const char *name);
	virtual Object_Stream *DoOpen(Environment &env, Signal sig,
			const char *name, const char *mode, const char *encoding);
};

}

#endif
