#ifndef __CONSOLE_H__
#define __CONSOLE_H__
#include "Common.h"
#include "String.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Console
//-----------------------------------------------------------------------------
class DLLDECLARE Console {
public:
	enum Error {
		ERROR_None,
		ERROR_Codec,
	};
private:
	String _encoding;
	Codec_Decoder *_pDecoder;
	Codec_Encoder *_pEncoder;
public:
	Console();
	virtual ~Console();
	bool InstallCodec(const char *encoding, bool processEOLFlag);
	void ReleaseCodec();
	inline bool IsCodecInstalled() const { return !_encoding.empty(); }
	inline const char *GetEncoding() const { return _encoding.c_str(); }
	inline Codec_Decoder *GetDecoder() { return _pDecoder; }
	inline Codec_Encoder *GetEncoder() { return _pEncoder; }
	int GetChar(Error *pError = NULL);
	void PutChar(char ch);
	void Print(const char *str);
	void Println(const char *str);
	void Printf(Signal sig, const char *format, const ValueList &valList);
	void PrintSignal(const Signal &sig);
	virtual int GetRawChar();
	virtual void PutRawChar(char ch);
	virtual void FlushConsole();
};

}

#endif
