//
// $Id$
//

#ifndef __BMPCODEC_H__
#define __BMPCODEC_H__

#include "Common.h"

class BMPCodec {
private:
	struct BitmapFileHeader {
		XPACKED_USHORT(bfType);
		XPACKED_ULONG(bfSize);
		XPACKED_USHORT(bfReserved1);
		XPACKED_USHORT(bfReserved2);
		XPACKED_ULONG(bfOffBits);
	};
	struct BitmapInfoHeader {
		XPACKED_ULONG(biSize);
		XPACKED_LONG(biWidth);
		XPACKED_LONG(biHeight);
		XPACKED_USHORT(biPlanes);
		XPACKED_USHORT(biBitCount);
		XPACKED_ULONG(biCompression);
		XPACKED_ULONG(biSizeImage);
		XPACKED_LONG(biXPelsPerMeter);
		XPACKED_LONG(biYPelsPerMeter);
		XPACKED_ULONG(biClrUsed);
		XPACKED_ULONG(biClrImportant);
	};
	struct Palette {
		UCHAR elemB, elemG, elemR, dummy;
	};
private:
	BitmapFileHeader _bfh;
	BitmapInfoHeader _bih;
public:
	class Stream {
	public:
		virtual ~Stream() {}
		virtual ULONG Read(void *buff, ULONG bytesToRead) = 0;
		virtual ULONG Write(void *buff, ULONG bytesToWrite) = 0;
		virtual void Seek(ULONG offset) = 0;
		virtual ULONG Tell() const = 0;
	};
	class ImageSrc {
	public:
		virtual void BeginEncode(int *pWidth, int *pHeight) = 0;
		virtual void GetAndScanPixelRGB(UCHAR &elemR, UCHAR &elemG, UCHAR &elemB) = 0;
		virtual void ScanLine() = 0;
	};
	class ImageDst {
	public:
		virtual void BeginDecode(int width, int height) = 0;
		virtual void PutAndScanPixelRGB(UCHAR elemR, UCHAR elemG, UCHAR elemB) = 0;
		virtual void ScanLine() = 0;
		virtual void EndDecode() = 0;
	};
	struct EncodeFlag {
	};
	struct DecodeFlag {
	};
public:
	BMPCodec();
	~BMPCodec();
	bool Encode(ImageSrc &image, const EncodeFlag &encodeFlag, Stream &stream);
	bool Decode(ImageDst &image, const DecodeFlag &decodeFlag, Stream &stream);
};

#endif
