#ifndef __OBJECT_EXPR_H__
#define __OBJECT_EXPR_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Expr / Object_Expr
//-----------------------------------------------------------------------------
class DLLDECLARE Class_Expr : public Class {
public:
	Class_Expr(Environment &env);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class DLLDECLARE Object_Expr : public Object {
public:
	class Iterator_Each : public Iterator {
	private:
		Environment _env;
		Expr_Container *_pExprContainer;
		ExprList::iterator _ppExpr;
	public:
		inline Iterator_Each(Environment &env, Expr_Container *pExprContainer) :
						Iterator(false), _env(env), _pExprContainer(pExprContainer),
						_ppExpr(pExprContainer->GetExprList().begin()) {}
		virtual ~Iterator_Each();
		virtual bool DoNext(Signal sig, Value &value);
		virtual String ToString(Signal sig) const;
	};
public:
	inline static Object_Expr *GetSelfObj(Context &context) {
		return dynamic_cast<Object_Expr *>(context.GetSelfObj());
	}
private:
	Expr *_pExpr;
public:
	inline Object_Expr(Class *pClass, Expr *pExpr) :
								Object(pClass), _pExpr(pExpr) {}
	Object_Expr(const Object_Expr &obj);
	virtual ~Object_Expr();
	virtual bool IsExpr() const;
	virtual Object *Clone() const;
	inline Expr *GetExpr() { return _pExpr; }
	inline const Expr *GetExpr() const { return _pExpr; }
	virtual String ToString(Signal sig, bool exprFlag);
};

}

#endif
