#ifndef __OBJECT_CODEC_H__
#define __OBJECT_CODEC_H__

#include "Object.h"
#include "Codec.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Codec
//-----------------------------------------------------------------------------
class DLLDECLARE Class_Codec : public Class {
public:
	Class_Codec(Environment &env);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

//-----------------------------------------------------------------------------
// Object_Codec
//-----------------------------------------------------------------------------
class DLLDECLARE Object_Codec : public Object {
public:
	inline static Object_Codec *GetSelfObj(Context &context) {
		return dynamic_cast<Object_Codec *>(context.GetSelfObj());
	}
private:
	String _encoding;
	Codec_Encoder *_pEncoder;
	Codec_Decoder *_pDecoder;
public:
	Object_Codec(Class *pClass);
	inline const char *GetEncoding() const { return _encoding.c_str(); }
	inline Codec_Encoder *GetEncoder() { return _pEncoder; }
	inline Codec_Decoder *GetDecoder() { return _pDecoder; }
	virtual ~Object_Codec();
	virtual Object *Clone() const;
	bool InstallCodec(Signal sig, const char *encoding, bool processEOLFlag);
	void ReleaseCodec();
	virtual String ToString(Signal sig, bool exprFlag);
};

}

#endif
