//
// Object_Codec
//

#include "Object_Codec.h"
#include "Object_Bytes.h"
#include "Object_String.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Object_Codec
//-----------------------------------------------------------------------------
Object_Codec::Object_Codec(Class *pClass) :
					Object(pClass), _pEncoder(NULL), _pDecoder(NULL)
{
}

Object_Codec::~Object_Codec()
{
	ReleaseCodec();
}

Object *Object_Codec::Clone() const
{
	return new Object_Codec(*this);
}

bool Object_Codec::InstallCodec(Signal sig, const char *encoding, bool processEOLFlag)
{
	if (encoding == NULL) encoding = "us-ascii";
	CodecFactory *pCodecFactory = CodecFactory::Lookup(encoding);
	if (pCodecFactory == NULL) {
		sig.SetError(ERR_CodecError, "unsupported encoding name %s", encoding);
		return false;
	}
	ReleaseCodec();
	_encoding = encoding;
	_pEncoder = pCodecFactory->CreateEncoder(processEOLFlag);
	_pDecoder = pCodecFactory->CreateDecoder(processEOLFlag);
	return true;
}

void Object_Codec::ReleaseCodec()
{
	_encoding.clear();
	delete _pEncoder;
	delete _pDecoder;
	_pEncoder = NULL;
	_pDecoder = NULL;
}

String Object_Codec::ToString(Signal sig, bool exprFlag)
{
	String str;
	str += "<codec:";
	str += _encoding;
	str += ">";
	return str;
}

//-----------------------------------------------------------------------------
// AScript interfaces for Object_Codec
//-----------------------------------------------------------------------------
// codec#encode(string:string):map
AScript_DeclareMethod(Codec, encode)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "string", VTYPE_String);
	SetHelp("");
}

AScript_ImplementMethod(Codec, encode)
{
	Object_Codec *pSelf = Object_Codec::GetSelfObj(context);
	Bytes dst;
	pSelf->GetEncoder()->Encode(dst, context.GetStringObj(0)->_GetString());
	Value result;
	result.InitAsBytes(env, dst);
	return result;
}

// codec#decode(buff:bytes):map
AScript_DeclareMethod(Codec, decode)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "buff", VTYPE_Bytes);
	SetHelp("");
}

AScript_ImplementMethod(Codec, decode)
{
	Object_Codec *pSelf = Object_Codec::GetSelfObj(context);
	String dst;
	pSelf->GetDecoder()->Decode(dst, context.GetBytes(0));
	return Value(env, dst.c_str());
}

// assignment
Class_Codec::Class_Codec(Environment &env) : Class(env.LookupClass(VTYPE_Object))
{
	AScript_AssignMethod(Codec, encode);
	AScript_AssignMethod(Codec, decode);
}

Object *Class_Codec::CreateDescendant(Environment &env, Signal sig, Class *pClass)
{
	ERROREND(env, "this function must not be called");
	return NULL;
}

}
