// opengl.glAreTexturesResident(textures[]:number)
AScript_DeclareFunction(glAreTexturesResident)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "textures", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glAreTexturesResident)
{
	const ValueList &textures_in = context.GetList(0);
	GLsizei n = static_cast<GLsizei>(textures_in.size());
	GLuint *textures = new GLuint[n];
	GLboolean *residences = new GLboolean[n];
	do {
		GLuint *p = textures;
		foreach_const (ValueList, pValue, textures_in) { *p++ = pValue->GetUInt(); }
	} while (0);
	// GLsizei n, const GLuint *textures, GLboolean *residences
	GLboolean rtn = ::glAreTexturesResident(n, textures, residences);
	if (rtn) {
		delete[] textures;
		delete[] residences;
		return Value(true);
	}
	Value result;
	ValueList &residences_out = result.InitAsList(env);
	do {
		GLboolean *p = residences;
		for (GLsizei i = 0; i < n; i++, p++) {
			residences_out.push_back(Value(*p? true : false));
		}
	} while (0);
	delete[] textures;
	delete[] residences;
	return result;
}

// opengl.glBegin(mode:number):void {block?}
AScript_DeclareFunction(glBegin)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "mode", VTYPE_Number);
	DeclareBlock(OCCUR_ZeroOrOnce);
}

AScript_ImplementFunction(glBegin)
{
	GLenum mode = context.GetUInt(0);
	// GLenum mode
	::glBegin(mode);
	if (context.IsBlockSpecified()) {
		const Expr_Block *pExprBlock = context.GetBlock(env, sig);
		if (sig.IsSignalled()) return Value::Null;
		pExprBlock->Exec(env, sig);
		::glEnd();
	}
	return Value::Null;
}

// opengl.glBitmap(width:number, height:number, xorig:number, yorig:number, xmove:number, ymove:number, bitmap:bytes):void
AScript_DeclareFunction(glBitmap)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "width", VTYPE_Number);
	DeclareArg(env, "height", VTYPE_Number);
	DeclareArg(env, "xorig", VTYPE_Number);
	DeclareArg(env, "yorig", VTYPE_Number);
	DeclareArg(env, "xmove", VTYPE_Number);
	DeclareArg(env, "ymove", VTYPE_Number);
	DeclareArg(env, "bitmap", VTYPE_Bytes);
}

AScript_ImplementFunction(glBitmap)
{
	GLsizei width = context.GetInt(0);
	GLsizei height = context.GetInt(1);
	GLfloat xorig = context.GetFloat(2);
	GLfloat yorig = context.GetFloat(3);
	GLfloat xmove = context.GetFloat(4);
	GLfloat ymove = context.GetFloat(5);
	GLubyte *bitmap = reinterpret_cast<GLubyte *>(const_cast<char *>(context.GetBytes(6).data()));
	// GLsizei width, GLsizei height, GLfloat xorig, GLfloat yorig, GLfloat xmove, GLfloat ymove, const GLubyte *bitmap
	::glBitmap(width, height, xorig, yorig, xmove, ymove, bitmap);
	return Value::Null;
}

// opengl.glCallLists(type:number, lists[]:number):void
AScript_DeclareFunction(glCallLists)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "type", VTYPE_Number);
	DeclareArg(env, "lists", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glCallLists)
{
	const ValueList &lists_in = context.GetList(1);
	GLsizei n = static_cast<GLsizei>(lists_in.size());
	GLenum type = context.GetUInt(0);
	GLvoid *lists = NULL;
	if (type == GL_BYTE) {
		lists = ::malloc(sizeof(GLbyte) * n);
		GLbyte *p = reinterpret_cast<GLbyte *>(lists);
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetChar(); }
	} else if (type == GL_UNSIGNED_BYTE) {
		lists = ::malloc(sizeof(GLubyte) * n);
		GLubyte *p = reinterpret_cast<GLubyte *>(lists);
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetUChar(); }
	} else if (type == GL_SHORT) {
		lists = ::malloc(sizeof(GLshort) * n);
		GLshort *p = reinterpret_cast<GLshort *>(lists);
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetShort(); }
	} else if (type == GL_UNSIGNED_SHORT) {
		lists = ::malloc(sizeof(GLushort) * n);
		GLushort *p = reinterpret_cast<GLushort *>(lists);
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetUShort(); }
	} else if (type == GL_INT) {
		lists = ::malloc(sizeof(GLint) * n);
		GLint *p = reinterpret_cast<GLint *>(lists);
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetInt(); }
	} else if (type == GL_UNSIGNED_INT) {
		lists = ::malloc(sizeof(GLuint) * n);
		GLuint *p = reinterpret_cast<GLuint *>(lists);
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetUInt(); }
	} else if (type == GL_FLOAT) {
		lists = ::malloc(sizeof(GLfloat) * n);
		GLfloat *p = reinterpret_cast<GLfloat *>(lists);
		foreach_const (ValueList, pValue, lists_in) { *p++ = pValue->GetFloat(); }
	} else if (type == GL_2_BYTES) {
		lists = ::malloc(sizeof(GLubyte) * 2 * n);
		GLubyte *p = reinterpret_cast<GLubyte *>(lists);
		foreach_const (ValueList, pValue, lists_in) {
			unsigned short num = pValue->GetUShort();
			*p++ = static_cast<GLubyte>(num >> 8);
			*p++ = static_cast<GLubyte>(num);
		}
	} else if (type == GL_3_BYTES) {
		lists = ::malloc(sizeof(GLubyte) * 3 * n);
		GLubyte *p = reinterpret_cast<GLubyte *>(lists);
		foreach_const (ValueList, pValue, lists_in) {
			unsigned long num = pValue->GetULong();
			*p++ = static_cast<GLubyte>(num >> 16);
			*p++ = static_cast<GLubyte>(num >> 8);
			*p++ = static_cast<GLubyte>(num);
		}
	} else if (type == GL_4_BYTES) {
		lists = ::malloc(sizeof(GLubyte) * 4 * n);
		GLubyte *p = reinterpret_cast<GLubyte *>(lists);
		foreach_const (ValueList, pValue, lists_in) {
			unsigned long num = pValue->GetULong();
			*p++ = static_cast<GLubyte>(num >> 24);
			*p++ = static_cast<GLubyte>(num >> 16);
			*p++ = static_cast<GLubyte>(num >> 8);
			*p++ = static_cast<GLubyte>(num);
		}
	} else {
		sig.SetError(ERR_ValueError, "invalid type specification");
		return Value::Null;
	}
	// GLsizei n, GLenum type, const GLvoid *lists
	::glCallLists(n, type, lists);
	::free(lists);
	return Value::Null;
}

// opengl.glDeleteTextures(textures[]:number):void
AScript_DeclareFunction(glDeleteTextures)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "textures", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glDeleteTextures)
{
	GLsizei n = static_cast<GLsizei>(context.GetList(0).size());
	DeclareNewArray(GLuint, textures, 0);
	// GLsizei n, const GLuint *textures
	::glDeleteTextures(n, textures);
	delete[] textures;
	return Value::Null;
}

// opengl.glDrawPixels(image:image):void
AScript_DeclareFunction(glDrawPixels)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "image", VTYPE_Image);
}

AScript_ImplementFunction(glDrawPixels)
{
	Object_Image *pObjImage = context.GetImageObj(0);
	GLsizei width = static_cast<GLsizei>(pObjImage->GetWidth());
	GLsizei height = static_cast<GLsizei>(pObjImage->GetHeight());
	GLenum format = GetImageFormat(sig, pObjImage);
	if (sig.IsSignalled()) return Value::Null;
	GLenum type = GL_UNSIGNED_BYTE;
	const GLvoid *pixels = pObjImage->GetBuffer();
	// GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels
	::glDrawPixels(width, height, format, type, pixels);
	return Value::Null;
}

// opengl.glFeedbackBuffer(size:number, type:number, buffer[]:number):void
AScript_DeclareFunction(glFeedbackBuffer)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "size", VTYPE_Number);
	DeclareArg(env, "type", VTYPE_Number);
	DeclareArg(env, "buffer", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glFeedbackBuffer)
{
	GLsizei size = context.GetInt(0);
	GLenum type = context.GetUInt(1);
	DeclareNewArray(GLfloat, buffer, 2);
	// GLsizei size, GLenum type, GLfloat *buffer
	//GL_2D, GL_3D, GL_3D_COLOR, GL_3D_COLOR_TEXTURE, GL_4D_COLOR_TEXTURE
	sig.SetError(ERR_SystemError, "not implemented");
	//::glFeedbackBuffer(size, type, buffer);
	delete[] buffer;
	return Value::Null;
}

// opengl.glGenLists(range:number):map
AScript_DeclareFunction(glGenLists)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "range", VTYPE_Number);
}

AScript_ImplementFunction(glGenLists)
{
	GLsizei range = context.GetInt(0);
	// GLsizei range
	return Value(::glGenLists(range));
}

// opengl.glGenTextures(n:number)
AScript_DeclareFunction(glGenTextures)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "n", VTYPE_Number);
}

AScript_ImplementFunction(glGenTextures)
{
	GLsizei n = context.GetInt(0);
	GLuint *textures = new GLuint[n];
	// GLsizei n, GLuint *textures
	::glGenTextures(n, textures);
	Value result;
	ValueList &textures_out = result.InitAsList(env);
	for (int i = 0; i < n; i++) {
		textures_out.push_back(Value(static_cast<unsigned int>(textures[i])));
	}
	delete[] textures;
	return result;
}

// opengl.glGetBooleanv(pname:number):map
AScript_DeclareFunction(glGetBooleanv)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "pname", VTYPE_Number);
}

AScript_ImplementFunction(glGetBooleanv)
{
	GLenum pname = context.GetUInt(0);
	size_t n = GetParamCount(pname);
	if (n == 0) {
		sig.SetError(ERR_ValueError, "invalid pname");
		return Value::Null;
	}
	GLboolean params[16];
	// GLenum pname, GLboolean *params
	::glGetBooleanv(pname, params);
	if (n == 1) return Value(params[0]? true : false);
	Value result;
	ValueList &params_out = result.InitAsList(env);
	for (size_t i = 0; i < n; i++) {
		params_out.push_back(params[i]? true : false);
	}
	return result;
}

// opengl.glGetDoublev(pname:number):map
AScript_DeclareFunction(glGetDoublev)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "pname", VTYPE_Number);
}

AScript_ImplementFunction(glGetDoublev)
{
	GLenum pname = context.GetUInt(0);
	size_t n = GetParamCount(pname);
	if (n == 0) {
		sig.SetError(ERR_ValueError, "invalid pname");
		return Value::Null;
	}
	GLdouble params[16];
	// GLenum pname, GLdouble *params
	::glGetDoublev(pname, params);
	if (n == 1) return Value(static_cast<double>(params[0]));
	Value result;
	ValueList &params_out = result.InitAsList(env);
	for (size_t i = 0; i < n; i++) {
		params_out.push_back(static_cast<double>(params[i]));
	}
	return result;
}

// opengl.glGetFloatv(pname:number):map
AScript_DeclareFunction(glGetFloatv)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "pname", VTYPE_Number);
}

AScript_ImplementFunction(glGetFloatv)
{
	GLenum pname = context.GetUInt(0);
	size_t n = GetParamCount(pname);
	if (n == 0) {
		sig.SetError(ERR_ValueError, "invalid pname");
		return Value::Null;
	}
	GLfloat params[16];
	// GLenum pname, GLfloat *params
	::glGetFloatv(pname, params);
	if (n == 1) return Value(static_cast<float>(params[0]));
	Value result;
	ValueList &params_out = result.InitAsList(env);
	for (size_t i = 0; i < n; i++) {
		params_out.push_back(static_cast<float>(params[i]));
	}
	return result;
}

// opengl.glGetIntegerv(pname:number):map
AScript_DeclareFunction(glGetIntegerv)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "pname", VTYPE_Number);
}

AScript_ImplementFunction(glGetIntegerv)
{
	GLenum pname = context.GetUInt(0);
	size_t n = GetParamCount(pname);
	if (n == 0) {
		sig.SetError(ERR_ValueError, "invalid pname");
		return Value::Null;
	}
	GLint params[16];
	// GLenum pname, GLint *params
	::glGetIntegerv(pname, params);
	if (n == 1) return Value(static_cast<int>(params[0]));
	Value result;
	ValueList &params_out = result.InitAsList(env);
	for (size_t i = 0; i < n; i++) {
		params_out.push_back(static_cast<int>(params[i]));
	}
	return result;
}

// opengl.glGetClipPlane(plane:number):map
AScript_DeclareFunction(glGetClipPlane)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "plane", VTYPE_Number);
}

AScript_ImplementFunction(glGetClipPlane)
{
	GLenum plane = context.GetUInt(0);
	GLdouble equation[4];
	// GLenum plane, GLdouble *equation
	::glGetClipPlane(plane, equation);
	Value result;
	ValueList &equation_out = result.InitAsList(env);
	for (size_t i = 0; i < 4; i++) {
		equation_out.push_back(static_cast<double>(equation[i]));
	}
	return result;
}

// opengl.glGetError()
AScript_DeclareFunction(glGetError)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementFunction(glGetError)
{
	GLenum err = ::glGetError();
	return Value(static_cast<unsigned int>(err));
}

// opengl.glGetLightfv(light:number, pname:number):map
AScript_DeclareFunction(glGetLightfv)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "light", VTYPE_Number);
	DeclareArg(env, "pname", VTYPE_Number);
}

AScript_ImplementFunction(glGetLightfv)
{
	GLenum light = context.GetUInt(0);
	GLenum pname = context.GetUInt(1);
	size_t n = GetParamCount(pname);
	if (n == 0) {
		sig.SetError(ERR_ValueError, "invalid pname");
		return Value::Null;
	}
	GLfloat params[4];
	// GLenum light, GLenum pname, GLfloat *params
	::glGetLightfv(light, pname, params);
	if (n == 1) return Value(static_cast<float>(params[0]));
	Value result;
	ValueList &params_out = result.InitAsList(env);
	for (size_t i = 0; i < n; i++) {
		params_out.push_back(static_cast<float>(params[i]));
	}
	return result;
}

// opengl.glGetLightiv(light:number, pname:number):map
AScript_DeclareFunction(glGetLightiv)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "light", VTYPE_Number);
	DeclareArg(env, "pname", VTYPE_Number);
}

AScript_ImplementFunction(glGetLightiv)
{
	GLenum light = context.GetUInt(0);
	GLenum pname = context.GetUInt(1);
	size_t n = GetParamCount(pname);
	if (n == 0) {
		sig.SetError(ERR_ValueError, "invalid pname");
		return Value::Null;
	}
	GLint params[4];
	// GLenum light, GLenum pname, GLint *params
	::glGetLightiv(light, pname, params);
	if (n == 1) return Value(static_cast<int>(params[0]));
	Value result;
	ValueList &params_out = result.InitAsList(env);
	for (size_t i = 0; i < n; i++) {
		params_out.push_back(static_cast<int>(params[i]));
	}
	return result;
}

//****************************************************

// opengl.glGetMapdv(target:number, query:number)
AScript_DeclareFunction(glGetMapdv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "target", VTYPE_Number);
	DeclareArg(env, "query", VTYPE_Number);
}

AScript_ImplementFunction(glGetMapdv)
{
	/*
	GL_MAP1_COLOR_4, GL_MAP1_INDEX, GL_MAP1_NORMAL,
	GL_MAP1_TEXTURE_COORD_1, GL_MAP1_TEXTURE_COORD_2,
	GL_MAP1_TEXTURE_COORD_3, GL_MAP1_TEXTURE_COORD_4,
	GL_MAP1_VERTEX_3, GL_MAP1_VERTEX_4,
	GL_MAP2_COLOR_4, GL_MAP2_INDEX, GL_MAP2_NORMAL,
	GL_MAP2_TEXTURE_COORD_1, GL_MAP2_TEXTURE_COORD_2,
	GL_MAP2_TEXTURE_COORD_3, GL_MAP2_TEXTURE_COORD_4,
	GL_MAP2_VERTEX_3, GL_MAP2_VERTEX_4
	*/
	/*
	GL_COEFF, GL_ORDER, GL_DOMAIN
	*/
	GLenum target = context.GetUInt(0);
	GLenum query = context.GetUInt(1);
	//DeclareNewArray(GLdouble, v, 2);
	// GLenum target, GLenum query, GLdouble *v
	sig.SetError(ERR_SystemError, "not implemented");
	//::glGetMapdv(target, query, v);
	//delete[] v;
	return Value::Null;
}

// opengl.glGetMapfv(target:number, query:number)
AScript_DeclareFunction(glGetMapfv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "target", VTYPE_Number);
	DeclareArg(env, "query", VTYPE_Number);
}

AScript_ImplementFunction(glGetMapfv)
{
	GLenum target = context.GetUInt(0);
	GLenum query = context.GetUInt(1);
	//DeclareNewArray(GLfloat, v, 2);
	// GLenum target, GLenum query, GLfloat *v
	sig.SetError(ERR_SystemError, "not implemented");
	//::glGetMapfv(target, query, v);
	//delete[] v;
	return Value::Null;
}

// opengl.glGetMapiv(target:number, query:number)
AScript_DeclareFunction(glGetMapiv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "target", VTYPE_Number);
	DeclareArg(env, "query", VTYPE_Number);
}

AScript_ImplementFunction(glGetMapiv)
{
	GLenum target = context.GetUInt(0);
	GLenum query = context.GetUInt(1);
	//DeclareNewArray(GLint, v, 2);
	// GLenum target, GLenum query, GLint *v
	sig.SetError(ERR_SystemError, "not implemented");
	//::glGetMapiv(target, query, v);
	//delete[] v;
	return Value::Null;
}

// opengl.glGetMaterialfv(face:number, pname:number)
AScript_DeclareFunction(glGetMaterialfv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "face", VTYPE_Number);
	DeclareArg(env, "pname", VTYPE_Number);
}

static size_t LookupMaterialVarLen(GLenum pname)
{
	static const struct {
		GLenum pname;
		size_t len;
	} tbl[] = {
		{ GL_AMBIENT,		4 },
		{ GL_DIFFUSE,		4 },
		{ GL_SPECULAR,		4 },
		{ GL_EMISSION,		4 },
		{ GL_SHININESS,		1 },
		{ GL_COLOR_INDEXES,	3 },
	};
	for (int i = 0; i < NUMBEROF(tbl); i++) {
		if (tbl[i].pname == pname) return tbl[i].len;
	}
	return 0;
}

AScript_ImplementFunction(glGetMaterialfv)
{
	GLenum face = context.GetUInt(0); //GL_FRONT, GL_BACK
	GLenum pname = context.GetUInt(1);
	GLfloat params[4];
	::glGetMaterialfv(face, pname, params);
	size_t len = LookupMaterialVarLen(pname);
	Value result;
	if (len > 0) {
		ValueList &valList = result.InitAsList(env);
		valList.reserve(len);
		for (size_t i = 0; i < len; i++) {
			valList.push_back(Value(params[i]));
		}
	}
	return result;
}

// opengl.glGetMaterialiv(face:number, pname:number)
AScript_DeclareFunction(glGetMaterialiv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "face", VTYPE_Number);
	DeclareArg(env, "pname", VTYPE_Number);
}

AScript_ImplementFunction(glGetMaterialiv)
{
	GLenum face = context.GetUInt(0); //GL_FRONT, GL_BACK
	GLenum pname = context.GetUInt(1);
	GLint params[4];
	::glGetMaterialiv(face, pname, params);
	size_t len = LookupMaterialVarLen(pname);
	Value result;
	if (len > 0) {
		ValueList &valList = result.InitAsList(env);
		valList.reserve(len);
		for (size_t i = 0; i < len; i++) {
			valList.push_back(Value(params[i]));
		}
	}
	return result;
}

// opengl.glGetPixelMapfv(map:number, values[]:number)
AScript_DeclareFunction(glGetPixelMapfv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "map", VTYPE_Number);
	DeclareArg(env, "values", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glGetPixelMapfv)
{
	GLenum map = context.GetUInt(0);
	DeclareNewArray(GLfloat, values, 1);
	// GLenum map, GLfloat *values
	sig.SetError(ERR_SystemError, "not implemented");
	//::glGetPixelMapfv(map, values);
	delete[] values;
	return Value::Null;
}

// opengl.glGetPixelMapuiv(map:number, values[]:number)
AScript_DeclareFunction(glGetPixelMapuiv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "map", VTYPE_Number);
	DeclareArg(env, "values", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glGetPixelMapuiv)
{
	GLenum map = context.GetUInt(0);
	DeclareNewArray(GLuint, values, 1);
	// GLenum map, GLuint *values
	sig.SetError(ERR_SystemError, "not implemented");
	//::glGetPixelMapuiv(map, values);
	delete[] values;
	return Value::Null;
}

// opengl.glGetPixelMapusv(map:number, values[]:number)
AScript_DeclareFunction(glGetPixelMapusv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "map", VTYPE_Number);
	DeclareArg(env, "values", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glGetPixelMapusv)
{
	GLenum map = context.GetUInt(0);
	DeclareNewArray(GLushort, values, 1);
	// GLenum map, GLushort *values
	sig.SetError(ERR_SystemError, "not implemented");
	//::glGetPixelMapusv(map, values);
	delete[] values;
	return Value::Null;
}

// opengl.glGetPointerv(pname:number, params[]:number)
AScript_DeclareFunction(glGetPointerv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "pname", VTYPE_Number);
	DeclareArg(env, "params", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glGetPointerv)
{
	GLenum pname = context.GetUInt(0);
	DeclareNewArray(int, params, 1);
	// GLenum pname, GLvoid* *params
	sig.SetError(ERR_SystemError, "not implemented");
	//::glGetPointerv(pname, params);
	delete[] params;
	return Value::Null;
}

// opengl.glGetPolygonStipple(mask[]:number)
AScript_DeclareFunction(glGetPolygonStipple)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "mask", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glGetPolygonStipple)
{
	DeclareNewArray(GLubyte, mask, 0);
	// GLubyte *mask
	sig.SetError(ERR_SystemError, "not implemented");
	//::glGetPolygonStipple(mask);
	delete[] mask;
	return Value::Null;
}

// opengl.glGetString(name:number):map
AScript_DeclareFunction(glGetString)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "name", VTYPE_Number);
}

AScript_ImplementFunction(glGetString)
{
	GLenum name = context.GetUInt(0);
	// GLenum name
	const GLubyte *rtn = ::glGetString(name);
	if (rtn == NULL) return Value::Null;
	return Value(env, reinterpret_cast<const char *>(rtn));
}

// opengl.glGetTexEnvfv(target:number, pname:number, params[]:number)
AScript_DeclareFunction(glGetTexEnvfv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "target", VTYPE_Number);
	DeclareArg(env, "pname", VTYPE_Number);
	DeclareArg(env, "params", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glGetTexEnvfv)
{
	GLenum target = context.GetUInt(0);
	GLenum pname = context.GetUInt(1);
	DeclareNewArray(GLfloat, params, 2);
	// GLenum target, GLenum pname, GLfloat *params
	sig.SetError(ERR_SystemError, "not implemented");
	//::glGetTexEnvfv(target, pname, params);
	delete[] params;
	return Value::Null;
}

// opengl.glGetTexEnviv(target:number, pname:number, params[]:number)
AScript_DeclareFunction(glGetTexEnviv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "target", VTYPE_Number);
	DeclareArg(env, "pname", VTYPE_Number);
	DeclareArg(env, "params", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glGetTexEnviv)
{
	GLenum target = context.GetUInt(0);
	GLenum pname = context.GetUInt(1);
	DeclareNewArray(GLint, params, 2);
	// GLenum target, GLenum pname, GLint *params
	sig.SetError(ERR_SystemError, "not implemented");
	//::glGetTexEnviv(target, pname, params);
	delete[] params;
	return Value::Null;
}

// opengl.glGetTexGendv(coord:number, pname:number, params[]:number)
AScript_DeclareFunction(glGetTexGendv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "coord", VTYPE_Number);
	DeclareArg(env, "pname", VTYPE_Number);
	DeclareArg(env, "params", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glGetTexGendv)
{
	GLenum coord = context.GetUInt(0);
	GLenum pname = context.GetUInt(1);
	DeclareNewArray(GLdouble, params, 2);
	// GLenum coord, GLenum pname, GLdouble *params
	//::glGetTexGendv(coord, pname, params);
	sig.SetError(ERR_SystemError, "not implemented");
	delete[] params;
	return Value::Null;
}

// opengl.glGetTexGenfv(coord:number, pname:number, params[]:number)
AScript_DeclareFunction(glGetTexGenfv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "coord", VTYPE_Number);
	DeclareArg(env, "pname", VTYPE_Number);
	DeclareArg(env, "params", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glGetTexGenfv)
{
	GLenum coord = context.GetUInt(0);
	GLenum pname = context.GetUInt(1);
	DeclareNewArray(GLfloat, params, 2);
	// GLenum coord, GLenum pname, GLfloat *params
	//::glGetTexGenfv(coord, pname, params);
	sig.SetError(ERR_SystemError, "not implemented");
	delete[] params;
	return Value::Null;
}

// opengl.glGetTexGeniv(coord:number, pname:number, params[]:number)
AScript_DeclareFunction(glGetTexGeniv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "coord", VTYPE_Number);
	DeclareArg(env, "pname", VTYPE_Number);
	DeclareArg(env, "params", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glGetTexGeniv)
{
	GLenum coord = context.GetUInt(0);
	GLenum pname = context.GetUInt(1);
	DeclareNewArray(GLint, params, 2);
	// GLenum coord, GLenum pname, GLint *params
	//::glGetTexGeniv(coord, pname, params);
	sig.SetError(ERR_SystemError, "not implemented");
	delete[] params;
	return Value::Null;
}

// opengl.glGetTexImage(target:number, level:number, format:number, type:number, pixels[]:number)
AScript_DeclareFunction(glGetTexImage)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "target", VTYPE_Number);
	DeclareArg(env, "level", VTYPE_Number);
	DeclareArg(env, "format", VTYPE_Number);
	DeclareArg(env, "type", VTYPE_Number);
	DeclareArg(env, "pixels", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glGetTexImage)
{
	GLenum target = context.GetUInt(0);
	GLint level = context.GetInt(1);
	GLenum format = context.GetUInt(2);
	GLenum type = context.GetUInt(3);
	DeclareNewArray(int, pixels, 4);
	// GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels
	sig.SetError(ERR_SystemError, "not implemented");
	//::glGetTexImage(target, level, format, type, pixels);
	delete[] pixels;
	return Value::Null;
}

// opengl.glGetTexLevelParameterfv(target:number, level:number, pname:number, params[]:number)
AScript_DeclareFunction(glGetTexLevelParameterfv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "target", VTYPE_Number);
	DeclareArg(env, "level", VTYPE_Number);
	DeclareArg(env, "pname", VTYPE_Number);
	DeclareArg(env, "params", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glGetTexLevelParameterfv)
{
	GLenum target = context.GetUInt(0);
	GLint level = context.GetInt(1);
	GLenum pname = context.GetUInt(2);
	DeclareNewArray(GLfloat, params, 3);
	// GLenum target, GLint level, GLenum pname, GLfloat *params
	sig.SetError(ERR_SystemError, "not implemented");
	//::glGetTexLevelParameterfv(target, level, pname, params);
	delete[] params;
	return Value::Null;
}

// opengl.glGetTexLevelParameteriv(target:number, level:number, pname:number, params[]:number)
AScript_DeclareFunction(glGetTexLevelParameteriv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "target", VTYPE_Number);
	DeclareArg(env, "level", VTYPE_Number);
	DeclareArg(env, "pname", VTYPE_Number);
	DeclareArg(env, "params", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glGetTexLevelParameteriv)
{
	GLenum target = context.GetUInt(0);
	GLint level = context.GetInt(1);
	GLenum pname = context.GetUInt(2);
	DeclareNewArray(GLint, params, 3);
	// GLenum target, GLint level, GLenum pname, GLint *params
	sig.SetError(ERR_SystemError, "not implemented");
	//::glGetTexLevelParameteriv(target, level, pname, params);
	delete[] params;
	return Value::Null;
}

// opengl.glGetTexParameterfv(target:number, pname:number, params[]:number)
AScript_DeclareFunction(glGetTexParameterfv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "target", VTYPE_Number);
	DeclareArg(env, "pname", VTYPE_Number);
	DeclareArg(env, "params", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glGetTexParameterfv)
{
	GLenum target = context.GetUInt(0);
	GLenum pname = context.GetUInt(1);
	DeclareNewArray(GLfloat, params, 2);
	// GLenum target, GLenum pname, GLfloat *params
	sig.SetError(ERR_SystemError, "not implemented");
	//::glGetTexParameterfv(target, pname, params);
	delete[] params;
	return Value::Null;
}

// opengl.glGetTexParameteriv(target:number, pname:number, params[]:number)
AScript_DeclareFunction(glGetTexParameteriv)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "target", VTYPE_Number);
	DeclareArg(env, "pname", VTYPE_Number);
	DeclareArg(env, "params", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glGetTexParameteriv)
{
	GLenum target = context.GetUInt(0);
	GLenum pname = context.GetUInt(1);
	DeclareNewArray(GLint, params, 2);
	// GLenum target, GLenum pname, GLint *params
	sig.SetError(ERR_SystemError, "not implemented");
	//::glGetTexParameteriv(target, pname, params);
	delete[] params;
	return Value::Null;
}

// opengl.glIsEnabled(cap:number):void:map
AScript_DeclareFunction(glIsEnabled)
{
	SetMode(RSLTMODE_Void, MAP_On, FLAT_Off);
	DeclareArg(env, "cap", VTYPE_Number);
}

AScript_ImplementFunction(glIsEnabled)
{
	GLenum cap = context.GetUInt(0);
	// GLenum cap
	return Value(::glIsEnabled(cap)? true : false);
}

// opengl.glIsList(list:number):void:map
AScript_DeclareFunction(glIsList)
{
	SetMode(RSLTMODE_Void, MAP_On, FLAT_Off);
	DeclareArg(env, "list", VTYPE_Number);
}

AScript_ImplementFunction(glIsList)
{
	GLuint list = context.GetUInt(0);
	// GLuint list
	return Value(::glIsList(list)? true : false);
}

// opengl.glIsTexture(texture:number):void:map
AScript_DeclareFunction(glIsTexture)
{
	SetMode(RSLTMODE_Void, MAP_On, FLAT_Off);
	DeclareArg(env, "texture", VTYPE_Number);
}

AScript_ImplementFunction(glIsTexture)
{
	GLuint texture = context.GetUInt(0);
	// GLuint texture
	return Value(::glIsTexture(texture)? true : false);
}

//****************************************************
// opengl.glNewList(list:number, mode:number):void:map {block?}
AScript_DeclareFunction(glNewList)
{
	SetMode(RSLTMODE_Void, MAP_On, FLAT_Off);
	DeclareArg(env, "list", VTYPE_Number);
	DeclareArg(env, "mode", VTYPE_Number);
	DeclareBlock(OCCUR_ZeroOrOnce);
}

AScript_ImplementFunction(glNewList)
{
	GLuint list = context.GetUInt(0);
	GLenum mode = context.GetUInt(1);
	// GLuint list, GLenum mode
	::glNewList(list, mode);
	if (context.IsBlockSpecified()) {
		const Expr_Block *pExprBlock = context.GetBlock(env, sig);
		if (sig.IsSignalled()) return Value::Null;
		pExprBlock->Exec(env, sig);
		::glEndList();
	}
	return Value::Null;
}

// opengl.glPolygonStipple(mask:bytes):void
AScript_DeclareFunction(glPolygonStipple)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "mask", VTYPE_Bytes);
}

AScript_ImplementFunction(glPolygonStipple)
{
	const Bytes &mask_in = context.GetBytes(0);
	if (mask_in.size() != 32 * 4) {
		sig.SetError(ERR_ValueError, "length of bytes must be 32 * 4");
		return Value::Null;
	}
	const GLubyte *mask = reinterpret_cast<const GLubyte *>(mask_in.data());
	// const GLubyte *mask
	::glPolygonStipple(mask);
	return Value::Null;
}

// opengl.glPrioritizeTextures(textures[]:number, priorities[]:number):void
AScript_DeclareFunction(glPrioritizeTextures)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "textures", VTYPE_Number, OCCUR_Once, true);
	DeclareArg(env, "priorities", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glPrioritizeTextures)
{
	if (context.GetList(0).size() != context.GetList(1).size()) {
		sig.SetError(ERR_ValueError, "textures and priorities must be in the same length");
		return Value::Null;
	}
	GLsizei n = static_cast<GLsizei>(context.GetList(0).size());
	DeclareNewArray(GLuint, textures, 0);
	DeclareNewArray(GLclampf, priorities, 1);
	// GLsizei n, const GLuint *textures, const GLclampf *priorities
	::glPrioritizeTextures(n, textures, priorities);
	delete[] textures;
	delete[] priorities;
	return Value::Null;
}

// opengl.glPushAttrib(mask:number):void {block?}
AScript_DeclareFunction(glPushAttrib)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "mask", VTYPE_Number);
	DeclareBlock(OCCUR_ZeroOrOnce);
}

AScript_ImplementFunction(glPushAttrib)
{
	GLbitfield mask = context.GetUInt(0);
	// GLbitfield mask
	::glPushAttrib(mask);
	if (context.IsBlockSpecified()) {
		const Expr_Block *pExprBlock = context.GetBlock(env, sig);
		if (sig.IsSignalled()) return Value::Null;
		pExprBlock->Exec(env, sig);
		::glPopAttrib();
	}
	return Value::Null;
}

// opengl.glPushClientAttrib(mask:number):void {block?}
AScript_DeclareFunction(glPushClientAttrib)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "mask", VTYPE_Number);
	DeclareBlock(OCCUR_ZeroOrOnce);
}

AScript_ImplementFunction(glPushClientAttrib)
{
	GLbitfield mask = context.GetUInt(0);
	// GLbitfield mask
	::glPushClientAttrib(mask);
	if (context.IsBlockSpecified()) {
		const Expr_Block *pExprBlock = context.GetBlock(env, sig);
		if (sig.IsSignalled()) return Value::Null;
		pExprBlock->Exec(env, sig);
		::glPopClientAttrib();
	}
	return Value::Null;
}

// opengl.glPushMatrix():void {block?}
AScript_DeclareFunction(glPushMatrix)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareBlock(OCCUR_ZeroOrOnce);
}

AScript_ImplementFunction(glPushMatrix)
{
	// void
	::glPushMatrix();
	if (context.IsBlockSpecified()) {
		const Expr_Block *pExprBlock = context.GetBlock(env, sig);
		if (sig.IsSignalled()) return Value::Null;
		pExprBlock->Exec(env, sig);
		::glPopMatrix();
	}
	return Value::Null;
}

// opengl.glPushName(name:number):void {block?}
AScript_DeclareFunction(glPushName)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "name", VTYPE_Number);
	DeclareBlock(OCCUR_ZeroOrOnce);
}

AScript_ImplementFunction(glPushName)
{
	GLuint name = context.GetUInt(0);
	// GLuint name
	::glPushName(name);
	if (context.IsBlockSpecified()) {
		const Expr_Block *pExprBlock = context.GetBlock(env, sig);
		if (sig.IsSignalled()) return Value::Null;
		pExprBlock->Exec(env, sig);
		::glPopName();
	}
	return Value::Null;
}

// opengl.glReadPixels(x:number, y:number, width:number, height:number, format:symbol)
AScript_DeclareFunction(glReadPixels)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "x", VTYPE_Number);
	DeclareArg(env, "y", VTYPE_Number);
	DeclareArg(env, "width", VTYPE_Number);
	DeclareArg(env, "height", VTYPE_Number);
	DeclareArg(env, "format", VTYPE_Symbol);
}

AScript_ImplementFunction(glReadPixels)
{
	GLint x = context.GetInt(0);
	GLint y = context.GetInt(1);
	GLsizei width = context.GetInt(2);
	GLsizei height = context.GetInt(3);
	Object_Image::Format fmt =
				Object_Image::SymbolToFormat(sig, context.GetSymbol(4));
	if (sig.IsSignalled()) return Value::Null;
	Object_Image *pObjImage = new Object_Image(env.LookupClass(VTYPE_Image), fmt);
	GLenum format = GetImageFormat(sig, pObjImage);
	if (sig.IsSignalled()) return Value::Null;
	if (!pObjImage->AllocBuffer(sig, width, height)) return Value::Null;
	GLenum type = GL_UNSIGNED_BYTE;
	::glReadPixels(x, y, width, height, format, type, pObjImage->GetBuffer());
	return Value(pObjImage, VTYPE_Image);
}

// opengl.glRectdv(v1[]:number, v2[]:number):void
AScript_DeclareFunction(glRectdv)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "v1", VTYPE_Number, OCCUR_Once, true);
	DeclareArg(env, "v2", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glRectdv)
{
	DeclareArray(GLdouble, v1, 2, 0);
	DeclareArray(GLdouble, v2, 2, 1);
	// const GLdouble *v1, const GLdouble *v2
	::glRectdv(v1, v2);
	return Value::Null;
}

// opengl.glRectfv(v1[]:number, v2[]:number):void
AScript_DeclareFunction(glRectfv)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "v1", VTYPE_Number, OCCUR_Once, true);
	DeclareArg(env, "v2", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glRectfv)
{
	DeclareArray(GLfloat, v1, 2, 0);
	DeclareArray(GLfloat, v2, 2, 1);
	// const GLfloat *v1, const GLfloat *v2
	::glRectfv(v1, v2);
	return Value::Null;
}

// opengl.glRectiv(v1[]:number, v2[]:number):void
AScript_DeclareFunction(glRectiv)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "v1", VTYPE_Number, OCCUR_Once, true);
	DeclareArg(env, "v2", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glRectiv)
{
	DeclareArray(GLint, v1, 2, 0);
	DeclareArray(GLint, v2, 2, 1);
	// const GLint *v1, const GLint *v2
	::glRectiv(v1, v2);
	return Value::Null;
}

// opengl.glRectsv(v1[]:number, v2[]:number):void
AScript_DeclareFunction(glRectsv)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "v1", VTYPE_Number, OCCUR_Once, true);
	DeclareArg(env, "v2", VTYPE_Number, OCCUR_Once, true);
}

AScript_ImplementFunction(glRectsv)
{
	DeclareArray(GLshort, v1, 2, 0);
	DeclareArray(GLshort, v2, 2, 1);
	// const GLshort *v1, const GLshort *v2
	::glRectsv(v1, v2);
	return Value::Null;
}

// opengl.glRenderMode(mode:number):void:map
AScript_DeclareFunction(glRenderMode)
{
	SetMode(RSLTMODE_Void, MAP_On, FLAT_Off);
	DeclareArg(env, "mode", VTYPE_Number);
}

AScript_ImplementFunction(glRenderMode)
{
	GLenum mode = context.GetUInt(0);
	// GLenum mode
	return Value(::glRenderMode(mode));
}

// opengl.glSelectBuffer(size:number)
AScript_DeclareFunction(glSelectBuffer)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "size", VTYPE_Number);
}

AScript_ImplementFunction(glSelectBuffer)
{
	GLsizei size = context.GetInt(0);
	GLuint *buffer = new GLuint[size];
	// GLsizei size, GLuint *buffer
	::glSelectBuffer(size, buffer);
	Value result;
	ValueList &buffer_out = result.InitAsList(env);
	for (int i = 0; i < size; i++) {
		buffer_out.push_back(Value(static_cast<unsigned int>(buffer[i])));
	}
	delete[] buffer;
	return result;
}

// opengl.glTexImage1D(target:number, level:number,
//                 internalformat:number, border:number, image:image):void
AScript_DeclareFunction(glTexImage1D)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "target", VTYPE_Number);
	DeclareArg(env, "level", VTYPE_Number);
	DeclareArg(env, "internalformat", VTYPE_Number);
	DeclareArg(env, "border", VTYPE_Number);
	DeclareArg(env, "image", VTYPE_Image);
}

AScript_ImplementFunction(glTexImage1D)
{
	Object_Image *pObjImage = context.GetImageObj(4);
	GLenum target = context.GetUInt(0);
	GLint level = context.GetInt(1);
	GLint internalformat = context.GetInt(2);
	GLint border = context.GetInt(3);
	GLsizei width = static_cast<GLsizei>(pObjImage->GetWidth()) + border * 2;
	GLenum format = GetImageFormat(sig, pObjImage);
	if (sig.IsSignalled()) return Value::Null;
	GLenum type = GL_UNSIGNED_BYTE;
	const GLvoid *pixels = pObjImage->GetBuffer();
	// GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels
	::glTexImage1D(target, level, internalformat, width, border, format, type, pixels);
	return Value::Null;
}

// opengl.glTexImage2D(target:number, level:number,
//                 internalformat:number, border:number, image:image):void
AScript_DeclareFunction(glTexImage2D)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "target", VTYPE_Number);
	DeclareArg(env, "level", VTYPE_Number);
	DeclareArg(env, "internalformat", VTYPE_Number);
	DeclareArg(env, "border", VTYPE_Number);
	DeclareArg(env, "image", VTYPE_Image);
}

AScript_ImplementFunction(glTexImage2D)
{
	Object_Image *pObjImage = context.GetImageObj(4);
	GLenum target = context.GetUInt(0);
	GLint level = context.GetInt(1);
	GLint internalformat = context.GetInt(2);
	GLint border = context.GetInt(3);
	GLsizei width = static_cast<GLsizei>(pObjImage->GetWidth()) + border * 2;
	GLsizei height = static_cast<GLsizei>(pObjImage->GetHeight()) + border * 2;
	GLenum format = GetImageFormat(sig, pObjImage);
	if (sig.IsSignalled()) return Value::Null;
	GLenum type = GL_UNSIGNED_BYTE;
	const GLvoid *pixels = pObjImage->GetBuffer();
	// GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels
	::glTexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
	return Value::Null;
}

// opengl.glTexSubImage1D(target:number, level:number, xoffset:number, image:image):void
AScript_DeclareFunction(glTexSubImage1D)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "target", VTYPE_Number);
	DeclareArg(env, "level", VTYPE_Number);
	DeclareArg(env, "xoffset", VTYPE_Number);
	DeclareArg(env, "image", VTYPE_Image);
}

AScript_ImplementFunction(glTexSubImage1D)
{
	Object_Image *pObjImage = context.GetImageObj(3);
	GLenum target = context.GetUInt(0);
	GLint level = context.GetInt(1);
	GLint xoffset = context.GetInt(2);
	GLsizei width = static_cast<GLsizei>(pObjImage->GetWidth());
	GLenum format = GetImageFormat(sig, pObjImage);
	if (sig.IsSignalled()) return Value::Null;
	GLenum type = GL_UNSIGNED_BYTE;
	const GLvoid *pixels = pObjImage->GetBuffer();
	// GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels
	::glTexSubImage1D(target, level, xoffset, width, format, type, pixels);
	return Value::Null;
}

// opengl.glTexSubImage2D(target:number, level:number, xoffset:number, yoffset:number, image:image):void
AScript_DeclareFunction(glTexSubImage2D)
{
	SetMode(RSLTMODE_Void, MAP_Off, FLAT_Off);
	DeclareArg(env, "target", VTYPE_Number);
	DeclareArg(env, "level", VTYPE_Number);
	DeclareArg(env, "xoffset", VTYPE_Number);
	DeclareArg(env, "yoffset", VTYPE_Number);
	DeclareArg(env, "image", VTYPE_Image);
}

AScript_ImplementFunction(glTexSubImage2D)
{
	Object_Image *pObjImage = context.GetImageObj(4);
	GLenum target = context.GetUInt(0);
	GLint level = context.GetInt(1);
	GLint xoffset = context.GetInt(2);
	GLint yoffset = context.GetInt(3);
	GLsizei width = static_cast<GLsizei>(pObjImage->GetWidth());
	GLsizei height = static_cast<GLsizei>(pObjImage->GetHeight());
	GLenum format = GetImageFormat(sig, pObjImage);
	if (sig.IsSignalled()) return Value::Null;
	GLenum type = GL_UNSIGNED_BYTE;
	const GLvoid *pixels = pObjImage->GetBuffer();
	// GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels
	::glTexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
	return Value::Null;
}
