//-----------------------------------------------------------------------------
// AScript jpeg module
//-----------------------------------------------------------------------------
#include <ascript.h>

AScript_BeginModule(jpeg)

//-----------------------------------------------------------------------------
// AScript interfaces for Object_Image
// These methods are available after importing jpeg module.
//-----------------------------------------------------------------------------
// image#readjpeg(file:file)
AScript_DeclareMethod(Image, readjpeg)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "file", VTYPE_File);
	SetHelp("Reads an image file in JPEG format.");
}

AScript_ImplementMethod(Image, readjpeg)
{
	Object_Image *pSelf = Object_Image::GetSelfObj(context);
	if (!pSelf->CheckEmpty(sig)) return Value::Null;
	return context.GetSelf();
}

// image#writejpeg(file:file)
AScript_DeclareMethod(Image, writejpeg)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "file", VTYPE_File);
	SetHelp("Writes an image file in JPEG format.");
}

AScript_ImplementMethod(Image, writejpeg)
{
	Object_Image *pSelf = Object_Image::GetSelfObj(context);
	if (!pSelf->CheckValidity(sig)) return Value::Null;
	return context.GetSelf();
}

//-----------------------------------------------------------------------------
// AScript module functions: jpeg
//-----------------------------------------------------------------------------
// Module entry
AScript_ModuleEntry()
{
	AScript_AssignMethodTo(VTYPE_Image, Image, readjpeg);
	AScript_AssignMethodTo(VTYPE_Image, Image, writejpeg);
}

AScript_ModuleTerminate()
{
}

AScript_EndModule(jpeg)

AScript_RegisterModule(jpeg)
