#include <stdio.h>
#include <vector>

typedef double Number;
typedef std::vector<Number> NumberList;

const Number Epsilon = 1.0e-6;

void Print(const NumberList &mat, size_t nFold)
{
	size_t nFold2 = nFold * 2;
	NumberList::const_iterator p = mat.begin();
	for (size_t iRow = 0; iRow < nFold; iRow++) {
		for (size_t n = nFold2; n > 0; n--, p++) {
			::printf("%12f", *p);
		}
		::printf("\n");
	}
}

bool InvertMatrix(NumberList &mat, size_t nFold)
{
	size_t nFold2 = nFold * 2;
	typedef std::vector<NumberList::iterator> Rows;
	Rows rows;
	size_t offset = 0;
	for (size_t iRow = 0; iRow < nFold; iRow++, offset += nFold * 2) {
		rows.push_back(mat.begin() + offset);
	}
	for (size_t iPivot = 0; iPivot < nFold; iPivot++) {
		size_t iRowMax = iPivot;
		Number nMax = ::fabs(*(rows[iRowMax] + iPivot));
		for (size_t iRow = iRowMax + 1; iRow < nFold; iRow++) {
			Number n = ::fabs(*(rows[iRow] + iPivot));
			if (nMax < n) {
				iRowMax = iRow;
				nMax = n;
			}
		}
		if (nMax < Epsilon) return false;
		if (iPivot != iRowMax) {
			NumberList::iterator p1 = rows[iPivot];
			NumberList::iterator p2 = rows[iRowMax];
			for (size_t cnt = nFold2; cnt > 0; cnt--, p1++, p2++) {
				std::swap(*p1, *p2);
			}
		}
		NumberList::iterator p_i = rows[iPivot];
		Number n = *(p_i + iPivot);
		for (size_t cnt = nFold2; cnt > 0; cnt--, p_i++) {
			*p_i /= n;
		}
		for (size_t j = 0; j < nFold; j++) {
			if (iPivot == j) continue;
			NumberList::iterator p_i = rows[iPivot], p_j = rows[j];
			Number factor = *(p_j + iPivot);
			for (size_t cnt = nFold2; cnt > 0; cnt--, p_i++, p_j++) {
				*p_j -= *p_i * factor;
			}
		}
	}
	return true;
}

main()
{
	size_t nCols = 2;
	Number matSrc[] = {
		2, 5,
		1, 4,
	};
#if 0
	size_t nCols = 3;
	Number matSrc[] = {
		3, 1, 1,
		4, 3 ,-1,
		8, 4, 1,
	};
#endif
#if 0
	size_t nCols = 3;
	Number matSrc[] = {
		2, 5, -1,
		1, 3, 1,
		3, -1, -2,
	};
#endif
	NumberList mat;
	mat.reserve(nCols * nCols * 2);
	Number *p = matSrc;
	for (size_t iRow = 0; iRow < nCols; iRow++) {
		for (size_t iCol = 0; iCol < nCols; iCol++, p++) {
			mat.push_back(*p);
		}
		for (size_t iCol = 0; iCol < nCols; iCol++) {
			mat.push_back((iCol == iRow)? 1. : 0.);
		}
	}
	Print(mat, nCols);
	InvertMatrix(mat, nCols);
	::printf("\n");
	Print(mat, nCols);
}
