#ifndef __OBJECT_SEMAPHORE_H__
#define __OBJECT_SEMAPHORE_H__

#include "Object.h"
#include "OAL.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Semaphore
//-----------------------------------------------------------------------------
class DLLDECLARE Class_Semaphore : public Class {
public:
	Class_Semaphore(Environment &env);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

//-----------------------------------------------------------------------------
// Object_Semaphore
//-----------------------------------------------------------------------------
class DLLDECLARE Object_Semaphore : public Object {
public:
	inline static Object_Semaphore *GetSelfObj(Context &context) {
		return dynamic_cast<Object_Semaphore *>(context.GetSelfObj());
	}
private:
	OAL::Semaphore _semaphore;
public:
	inline Object_Semaphore(Class *pClass) : Object(pClass) {}
	inline OAL::Semaphore &GetSemaphore() { return _semaphore; }
	virtual ~Object_Semaphore();
	virtual Object *Clone() const;
	virtual String ToString(Signal sig, bool exprFlag);
};

}

#endif
