//
// Object_DateTime
//

#include "Object_DateTime.h"
#include "Expr.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Object_DateTime
//-----------------------------------------------------------------------------
Object_DateTime::Object_DateTime(const Object_DateTime &obj) :
										Object(obj), _dateTime(obj._dateTime)
{
}

Object_DateTime::~Object_DateTime()
{
}

Object *Object_DateTime::Clone() const
{
	return new Object_DateTime(*this);
}

String Object_DateTime::ToString(Signal sig, bool exprFlag)
{
	String str;
	str += "<datetime:";
	str += _dateTime.ToString("%Y-%m-%d %H:%M:%S");
	str += ">";
	return str;
}

//-----------------------------------------------------------------------------
// AScript interfaces for Object_DateTime
//-----------------------------------------------------------------------------
// datetime#year()
AScript_DeclareMethod(DateTime, year)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	SetHelp("Returns a year number of the datetime object.");
}

AScript_ImplementMethod(DateTime, year)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetYear()));
}

// datetime#month()
AScript_DeclareMethod(DateTime, month)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	SetHelp(
	"Returns a month number of the datetime object. The value is between 1 and 12.");
}

AScript_ImplementMethod(DateTime, month)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetMonth()));
}

// datetime#day()
AScript_DeclareMethod(DateTime, day)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	SetHelp(
	"Returns a day number of month of the datetime object. The value is between 1 and 31.");
}

AScript_ImplementMethod(DateTime, day)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetDay()));
}

// datetime#hour()
AScript_DeclareMethod(DateTime, hour)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	SetHelp(
	"Returns an hour number of the datetime object. The value is between 0 and 23.");
}

AScript_ImplementMethod(DateTime, hour)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetHour()));
}

// datetime#min()
AScript_DeclareMethod(DateTime, min)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	SetHelp(
	"Returns a minute number of the datetime object. The value is between 0 and 59.");
}

AScript_ImplementMethod(DateTime, min)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetMin()));
}

// datetime#sec()
AScript_DeclareMethod(DateTime, sec)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	SetHelp(
	"Returns a second number of the datetime object. The value is between 0 and 59.");
}

AScript_ImplementMethod(DateTime, sec)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetSec()));
}

// datetime#usec()
AScript_DeclareMethod(DateTime, usec)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	SetHelp(
	"Returns a micro second number of the datetime object. The value is between 0 and 999999.");
}

AScript_ImplementMethod(DateTime, usec)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetUSec()));
}

// datetime#wday()
// 0:Sun, 1:Mon, 2:Tue, 3:Wed, 4:Thu, 5:Fri, 6:Sat
AScript_DeclareMethod(DateTime, wday)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	SetHelp(
	"Returns a week index of the datetime object. Zero value corresponds to Sunday.");
}

AScript_ImplementMethod(DateTime, wday)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetDayOfWeek()));
}

// datetime#yday()
AScript_DeclareMethod(DateTime, yday)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	SetHelp(
	"Returns a passing day in the year. Zero value corresponds to January 1st");
}

AScript_ImplementMethod(DateTime, yday)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(static_cast<Number>(dateTime.GetDayOfYear() + 1));
}

// datetime#format(format:string)
AScript_DeclareMethod(DateTime, format)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "format", VTYPE_String);
	SetHelp(
	"Returns a string after converting datetime properties with the specified format.\n"
	"The format can contain following format specifiers.\n"
	"%d  day of month\n"
	"%H  hour in 24-hour format\n"
	"%I  hour in 12-hour format\n"
	"%m  month\n"
	"%M  minute\n"
	"%S  second\n"
	"%w  day of week\n"
	"%y  lower two digits of year\n"
	"%Y  year");
}

AScript_ImplementMethod(DateTime, format)
{
	const DateTime &dateTime = Object_DateTime::GetSelfObj(context)->GetDateTime();
	return Value(env, dateTime.ToString(context.GetString(0)).c_str());
}

// assignment
Class_DateTime::Class_DateTime(Environment &env) : Class(env.LookupClass(VTYPE_Object))
{
	AScript_AssignMethod(DateTime, year);
	AScript_AssignMethod(DateTime, month);
	AScript_AssignMethod(DateTime, day);
	AScript_AssignMethod(DateTime, hour);
	AScript_AssignMethod(DateTime, min);
	AScript_AssignMethod(DateTime, sec);
	AScript_AssignMethod(DateTime, usec);
	AScript_AssignMethod(DateTime, wday);
	AScript_AssignMethod(DateTime, yday);
	AScript_AssignMethod(DateTime, format);
}

Object *Class_DateTime::CreateDescendant(Environment &env, Signal sig, Class *pClass)
{
	ERROREND(env, "this function must not be called");
	return NULL;
}

}
