// OAL: OS Abstraction Layer
#ifndef __OAL_H__
#define __OAL_H__
#include "Common.h"
#if defined(HAVE_SEMAPHORE_H)
#include <semaphore.h>
#endif

namespace AScript {
namespace OAL {

DLLDECLARE const char *getenv(const char *name);
DLLDECLARE void rename(const char *src, const char *dst);
DLLDECLARE void remove(const char *pathName);
DLLDECLARE bool mkdir(const char *pathName, bool recursiveFlag);
DLLDECLARE bool chdir(const char *pathName);
DLLDECLARE String getcwd();
DLLDECLARE void exec(const char *pathName, const char **argv);
DLLDECLARE void Sleep(Number delay);

class DLLDECLARE Thread {
public:
	void Start();
	virtual void Run() = 0;
};

class DLLDECLARE Semaphore {
private:
#if defined(HAVE_WINDOWS_H)
	HANDLE _hMutex;
#elif defined(HAVE_SEMAPHORE_H)
	sem_t _sem;
#endif
public:
	Semaphore();
	~Semaphore();
	void Wait();
	void Release();
};

class DLLDECLARE Event {
private:
#if defined(HAVE_WINDOWS_H)
	HANDLE _hEvent;
#else
#endif
public:
	Event();
	~Event();
	void Wait();
	void Notify();
};

}
}

#endif
