#ifndef __OBJECT_EXPR_H__
#define __OBJECT_EXPR_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Expr / Object_Expr
//-----------------------------------------------------------------------------
class Class_Expr : public Class {
public:
	Class_Expr(Class *pClassSuper, const Symbol *pSymbol);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class Object_Expr : public Object {
public:
	inline static Object_Expr *GetSelfObj(Context &context) {
		return dynamic_cast<Object_Expr *>(context.GetSelfObj());
	}
private:
	Expr *_pExpr;
public:
	inline Object_Expr(Class *pClass, Expr *pExpr) :
								Object(pClass), _pExpr(pExpr) {}
	Object_Expr(const Object_Expr &obj);
	virtual ~Object_Expr();
	virtual bool IsExpr() const;
	virtual Object *Clone() const;
	inline Expr *GetExpr() { return _pExpr; }
	inline const Expr *GetExpr() const { return _pExpr; }
	virtual String ToString(Signal sig, bool exprFlag);
};

}

#endif
