#ifndef __OBJECT_MATRIX_H__
#define __OBJECT_MATRIX_H__

#include "Object_List.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Matrix
//-----------------------------------------------------------------------------
class Class_Matrix : public Class_List {
public:
	Class_Matrix(Class *pClassSuper, const Symbol *pSymbol);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

//-----------------------------------------------------------------------------
// Object_Matrix
//-----------------------------------------------------------------------------
class Object_Matrix : public Object_List {
public:
	class Constructor : public ConstructorBase {
	public:
		Constructor(Environment &env, const char *name = AScript_Symbol(Matrix)->GetName());
		virtual Value DoEval(Environment &env, Signal sig, Context &context) const;
	};
public:
	inline Object_Matrix(Class *pClass) : Object_List(pClass) {}
	inline Object_Matrix(Class *pClass, size_t n, const Value &value) :
									Object_List(pClass, n, value) {}
	inline Object_Matrix(const Object_Matrix &obj) :
									Object_List(obj) {}
	//virtual bool IsMatrix() const;
	virtual Object *Clone() const;
};

}

#endif
