//
// Object_FileStat
//

#include "Object_FileStat.h"
#include "Object_DateTime.h"
#include "Expr.h"

namespace AScript {

Object_FileStat::Object_FileStat(const Object_FileStat &obj) :
										Object(obj), _fileStat(obj._fileStat)
{
}

Object_FileStat::~Object_FileStat()
{
}

Object *Object_FileStat::Clone() const
{
	return new Object_FileStat(*this);
}

String Object_FileStat::ToString(Signal sig, bool exprFlag)
{
	String str;
	str += "<FileStat:";
	str += _fileStat.GetPathName();
	str += ">";
	return str;
}

// FileStat#pathname()
AScript_DeclareMethod(FileStat, pathname)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, pathname)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(env, fileStat.GetPathName());
}

// FileStat#basename()
AScript_DeclareMethod(FileStat, basename)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, basename)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(env, File::ExtractBaseName(fileStat.GetPathName()).c_str());
}

// FileStat#dirname()
AScript_DeclareMethod(FileStat, dirname)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, dirname)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(env, File::ExtractDirName(fileStat.GetPathName()).c_str());
}

// FileStat#size()
AScript_DeclareMethod(FileStat, size)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, size)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(static_cast<Number>(fileStat.GetSize()));
}

// FileStat#uid()
AScript_DeclareMethod(FileStat, uid)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, uid)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(static_cast<Number>(fileStat.GetUid()));
}

// FileStat#gid()
AScript_DeclareMethod(FileStat, gid)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, gid)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(static_cast<Number>(fileStat.GetGid()));
}

// FileStat#atime()
AScript_DeclareMethod(FileStat, atime)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, atime)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	Object_DateTime *pObj =
			new Object_DateTime(env.GetClass_DateTime(), fileStat.GetATime());
	return Value(pObj, VTYPE_DateTime);
}

// FileStat#mtime()
AScript_DeclareMethod(FileStat, mtime)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, mtime)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	Object_DateTime *pObj =
			new Object_DateTime(env.GetClass_DateTime(), fileStat.GetMTime());
	return Value(pObj, VTYPE_DateTime);
}

// FileStat#ctime()
AScript_DeclareMethod(FileStat, ctime)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, ctime)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	Object_DateTime *pObj =
			new Object_DateTime(env.GetClass_DateTime(), fileStat.GetCTime());
	return Value(pObj, VTYPE_DateTime);
}

// FileStat#is_dir()
AScript_DeclareMethod(FileStat, is_dir)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, is_dir)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(fileStat.IsDir());
}

// FileStat#is_chr()
AScript_DeclareMethod(FileStat, is_chr)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, is_chr)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(fileStat.IsChr());
}

// FileStat#is_blk()
AScript_DeclareMethod(FileStat, is_blk)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, is_blk)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(fileStat.IsBlk());
}

// FileStat#is_reg()
AScript_DeclareMethod(FileStat, is_reg)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, is_reg)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(fileStat.IsReg());
}

// FileStat#is_fifo()
AScript_DeclareMethod(FileStat, is_fifo)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, is_fifo)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(fileStat.IsFifo());
}

// FileStat#is_lnk()
AScript_DeclareMethod(FileStat, is_lnk)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, is_lnk)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(fileStat.IsLnk());
}

// FileStat#is_sock()
AScript_DeclareMethod(FileStat, is_sock)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(FileStat, is_sock)
{
	const FileStat &fileStat = Object_FileStat::GetSelfObj(context)->GetFileStat();
	return Value(fileStat.IsSock());
}

Class_FileStat::Class_FileStat(Class *pClassSuper, const Symbol *pSymbol) :
												Class(pClassSuper, pSymbol)
{
	AScript_AssignMethod(FileStat, pathname);
	AScript_AssignMethod(FileStat, basename);
	AScript_AssignMethod(FileStat, dirname);
	AScript_AssignMethod(FileStat, size);
	AScript_AssignMethod(FileStat, uid);
	AScript_AssignMethod(FileStat, gid);
	AScript_AssignMethod(FileStat, atime);
	AScript_AssignMethod(FileStat, mtime);
	AScript_AssignMethod(FileStat, ctime);
	AScript_AssignMethod(FileStat, is_dir);
	AScript_AssignMethod(FileStat, is_chr);
	AScript_AssignMethod(FileStat, is_blk);
	AScript_AssignMethod(FileStat, is_reg);
	AScript_AssignMethod(FileStat, is_fifo);
	AScript_AssignMethod(FileStat, is_lnk);
	AScript_AssignMethod(FileStat, is_sock);
}

Object *Class_FileStat::CreateDescendant(Environment &env, Signal sig, Class *pClass)
{
	ERROREND(env, "this function must not be called");
	return NULL;
}

}
