//
// Object_Expr
//

#include "Object_Expr.h"
#include "Expr.h"

#define ImplementTypeChecker(funcName, func)	\
AScript_DeclareMethod(Expr, funcName) {}		\
AScript_ImplementMethod(Expr, funcName) { return Value(Object_Expr::GetSelfObj(context)->GetExpr()->func()); }

namespace AScript {

bool Object_Expr::IsExpr() const { return true; }

Object_Expr::Object_Expr(const Object_Expr &obj) :
								Object(obj), _pExpr(obj._pExpr->IncRef())
{
}

Object_Expr::~Object_Expr()
{
	Expr::Delete(_pExpr);
}

Object *Object_Expr::Clone() const
{
	return new Object_Expr(*this);
}

String Object_Expr::ToString(Signal sig, bool exprFlag)
{
	String str;
	if (_pExpr->IsValue() || _pExpr->IsSymbol() || _pExpr->IsCaller()) {
		if (exprFlag) str += '`';
		str += _pExpr->ToString(sig);
	} else if (exprFlag) {
		if (_pExpr->IsUnary() || _pExpr->IsBinary()) {
			str += "`(";
			str += _pExpr->ToString(sig);
			str += ")";
		} else {
			str += "`";
			str += _pExpr->ToString(sig);
		}
	} else {
		str += _pExpr->ToString(sig);
	}
	return str;
}

// Expr#child()
AScript_DeclareMethod(Expr, child)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(Expr, child)
{
	const Expr *pExpr = Object_Expr::GetSelfObj(context)->GetExpr();
	if (!pExpr->IsUnary()) {
		sig.SetError(ERR_ValueError, "not a unary expression");
		return Value::Null;
	}
	Value result;
	result.InitAsExpr(env,
			dynamic_cast<const Expr_Unary *>(pExpr)->GetChild()->IncRef());
	return result;
}

// Expr#left()
AScript_DeclareMethod(Expr, left)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(Expr, left)
{
	const Expr *pExpr = Object_Expr::GetSelfObj(context)->GetExpr();
	if (!pExpr->IsBinary()) {
		sig.SetError(ERR_ValueError, "not a binary expression");
		return Value::Null;
	}
	Value result;
	result.InitAsExpr(env,
			dynamic_cast<const Expr_Binary *>(pExpr)->GetLeft()->IncRef());
	return result;
}

// Expr#right()
AScript_DeclareMethod(Expr, right)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(Expr, right)
{
	const Expr *pExpr = Object_Expr::GetSelfObj(context)->GetExpr();
	if (!pExpr->IsBinary()) {
		sig.SetError(ERR_ValueError, "not a binary expression");
		return Value::Null;
	}
	Value result;
	result.InitAsExpr(env,
			dynamic_cast<const Expr_Binary *>(pExpr)->GetRight()->IncRef());
	return result;
}

// Expr#each() {block}
AScript_DeclareMethod(Expr, each)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareBlock(OCCUR_Once);
}

AScript_ImplementMethod(Expr, each)
{
	const Expr *pExpr = Object_Expr::GetSelfObj(context)->GetExpr();
	if (!pExpr->IsContainer()) {
		sig.SetError(ERR_ValueError, "not a container expression");
		return Value::Null;
	}
	const Expr_Container *pExprContainer =
							dynamic_cast<const Expr_Container *>(pExpr);
	const Function *pFuncBlock = GetBlockFunction(env, sig, context);
	if (sig.IsSignalled()) return Value::Null;
	Environment envBlock(&env, ENVTYPE_Block);
	foreach_const (ExprList, ppExprEach, pExprContainer->GetExprList()) {
		const Expr *pExprEach = *ppExprEach;
		Object_Expr *pObj = new Object_Expr(env.GetClass_Expr(), pExprEach->IncRef());
		Value value(pObj, VTYPE_Object);
		ValueList valListArg(value);
		Context contextSub(valListArg);
		pFuncBlock->Eval(envBlock, sig, contextSub);
		AScript_BlockSignalHandlerInLoop(sig, value, Value::Null)
	}
	return Value::Null;
}

// Expr#car()
AScript_DeclareMethod(Expr, car)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(Expr, car)
{
	const Expr *pExpr = Object_Expr::GetSelfObj(context)->GetExpr();
	if (!pExpr->IsComplex()) {
		sig.SetError(ERR_ValueError, "not a complex expression");
		return Value::Null;
	}
	Value result;
	result.InitAsExpr(env,
			dynamic_cast<const Expr_Complex *>(pExpr)->GetCar()->IncRef());
	return result;
}

// Expr#cdr()
AScript_DeclareMethod(Expr, cdr)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(Expr, cdr)
{
	const Expr *pExpr = Object_Expr::GetSelfObj(context)->GetExpr();
	if (!pExpr->IsComplex()) {
		sig.SetError(ERR_ValueError, "not a complex expression");
		return Value::Null;
	}
	Value result;
	ValueList &valList = result.InitAsList(env);
	foreach_const (ExprList, ppExpr,
					dynamic_cast<const Expr_Complex *>(pExpr)->GetExprList()) {
		const Expr *pExpr = *ppExpr;
		Value value;
		value.InitAsExpr(env, pExpr->IncRef());
		valList.push_back(value);
	}
	return result;
}

// Expr#exprname()
AScript_DeclareMethod(Expr, exprname)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(Expr, exprname)
{
	const Expr *pExpr = Object_Expr::GetSelfObj(context)->GetExpr();
	return Value(env, pExpr->GetTypeName());
}

// Expr#to_function()
AScript_DeclareMethod(Expr, to_function)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(Expr, to_function)
{
	const Expr *pExpr = Object_Expr::GetSelfObj(context)->GetExpr();
	Expr_Block *pExprBlock;
	if (pExpr->IsBlock()) {
		pExprBlock = dynamic_cast<Expr_Block *>(
							dynamic_cast<const Expr_Block *>(pExpr)->IncRef());
	} else {
		pExprBlock = new Expr_Block();
		pExprBlock->AddExpr(pExpr->IncRef());
	}
	Value result;
	FunctionCustom *pFunc = CreateBlockFunc(env, sig, pExprBlock, FUNCTYPE_Function);
	if (sig.IsSignalled()) return Value::Null;
	pFunc->SetSymbol(AScript_Symbol(_anonymous_));
	result.InitAsFunction(env, pFunc);
	return result;
}

// type chekers
ImplementTypeChecker(is_unary,		IsUnary)
ImplementTypeChecker(is_unaryop,	IsUnaryOp)
ImplementTypeChecker(is_quote,		IsQuote)
ImplementTypeChecker(is_force,		IsForce)
ImplementTypeChecker(is_prefix,		IsPrefix)
ImplementTypeChecker(is_suffix,		IsSuffix)

ImplementTypeChecker(is_binary,		IsBinary)
ImplementTypeChecker(is_binaryop,	IsBinaryOp)
ImplementTypeChecker(is_assign,		IsAssign)
ImplementTypeChecker(is_dictassign,	IsDictAssign)
ImplementTypeChecker(is_field,		IsField)

ImplementTypeChecker(is_container,	IsContainer)
ImplementTypeChecker(is_blockparam,	IsBlockParam)
ImplementTypeChecker(is_block,		IsBlock)
ImplementTypeChecker(is_lister,		IsLister)

ImplementTypeChecker(is_value,		IsValue)
ImplementTypeChecker(is_symbol,		IsSymbol)
ImplementTypeChecker(is_indexer,	IsIndexer)
ImplementTypeChecker(is_caller,		IsCaller)

// Assignment
Class_Expr::Class_Expr(Class *pClassSuper, const Symbol *pSymbol) :
												Class(pClassSuper, pSymbol)
{
	AScript_AssignMethod(Expr, child);
	AScript_AssignMethod(Expr, left);
	AScript_AssignMethod(Expr, right);
	AScript_AssignMethod(Expr, each);
	//AScript_AssignMethod(Expr, children);
	AScript_AssignMethod(Expr, car);
	AScript_AssignMethod(Expr, cdr);
	AScript_AssignMethod(Expr, exprname);
	AScript_AssignMethod(Expr, to_function);
	AScript_AssignMethod(Expr, is_unary);
	AScript_AssignMethod(Expr, is_unaryop);
	AScript_AssignMethod(Expr, is_quote);
	AScript_AssignMethod(Expr, is_force);
	AScript_AssignMethod(Expr, is_prefix);
	AScript_AssignMethod(Expr, is_suffix);
	AScript_AssignMethod(Expr, is_binary);
	AScript_AssignMethod(Expr, is_binaryop);
	AScript_AssignMethod(Expr, is_assign);
	AScript_AssignMethod(Expr, is_dictassign);
	AScript_AssignMethod(Expr, is_field);
	AScript_AssignMethod(Expr, is_container);
	AScript_AssignMethod(Expr, is_blockparam);
	AScript_AssignMethod(Expr, is_block);
	AScript_AssignMethod(Expr, is_lister);
	AScript_AssignMethod(Expr, is_value);
	AScript_AssignMethod(Expr, is_symbol);
	AScript_AssignMethod(Expr, is_indexer);
	AScript_AssignMethod(Expr, is_caller);
}

Object *Class_Expr::CreateDescendant(Environment &env, Signal sig, Class *pClass)
{
	ERROREND(env, "this function must not be called");
	return NULL;
}

}
