//
// Object_Struct
//

#include "Object_Struct.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Object_Struct
//-----------------------------------------------------------------------------
Object_Struct::Object_Struct(const Object_Struct &obj) : Object(obj)
{
}

Object_Struct::~Object_Struct()
{
}

Object *Object_Struct::Clone() const
{
	return new Object_Struct(*this);
}

String Object_Struct::ToString(Signal sig, bool exprFlag)
{
	bool evaluatedFlag = false;
	Value value = EvalMethod(sig, AScript_Symbol(__str__),
											ValueList::Null, evaluatedFlag);
	if (evaluatedFlag) return value.ToString(sig, false);
	String str;
	str += _pClass->GetName();
	str += "(";
	const DeclarationList &declList = GetDeclList();
	foreach_const (DeclarationList, ppDecl, declList) {
		const Declaration *pDecl = *ppDecl;
		if (ppDecl != declList.begin()) str += ", ";
		str += pDecl->GetSymbol()->GetName();
		str += " => ";
		const Value *pValue = LookupValue(pDecl->GetSymbol(), false);
		if (pValue == NULL) {
			str += "nil";
		} else {
			str += pValue->ToString(sig, true);
		}
	}
	str += ")";
	return str;
}

const DeclarationList &Object_Struct::GetDeclList() const
{
	const Function *pConstructor = _pClass->GetConstructor();
	return pConstructor->GetDeclList();
}

#if 0
const Value *Object_Struct::LookupValue() const
{
	const Environment::Frame &frame = GetTopFrame();
	const ValueMap &valueMap = frame.GetValueMap();
	ValueMap::const_iterator iter = valueMap.find(pDecl->GetSymbol());
	return (iter == valueMap.end())? NULL : &iter->second;
}
#endif

//-----------------------------------------------------------------------------
// AScript interfaces for Object_Struct
//-----------------------------------------------------------------------------
// Struct#to_list()
AScript_DeclareMethod(Struct, to_list)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementMethod(Struct, to_list)
{
	Object_Struct *pSelf = Object_Struct::GetSelfObj(context);
	Value result;
	ValueList &valList = result.InitAsList(env);
	const DeclarationList &declList = pSelf->GetDeclList();
	foreach_const (DeclarationList, ppDecl, declList) {
		const Value *pValue = pSelf->LookupValue((*ppDecl)->GetSymbol(), false);
		if (pValue == NULL) {
			valList.push_back(Value::Null);
		} else {
			valList.push_back(*pValue);
		}
	}
	return result;
}

// assignment
Class_Struct::Class_Struct(Class *pClassSuper, const Symbol *pSymbol) :
												Class(pClassSuper, pSymbol)
{
	AScript_AssignMethod(Struct, to_list);
}

Object *Class_Struct::CreateDescendant(Environment &env, Signal sig, Class *pClass)
{
	return new Object_Struct((pClass == NULL)? this : pClass);
}

}
