#ifndef __OBJECT_STRING_H__
#define __OBJECT_STRING_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_String / Object_String
//-----------------------------------------------------------------------------
class Class_String : public Class {
public:
	Class_String(Class *pClassSuper, const Symbol *pSymbol);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class Object_String : public Object {
public:
	class IteratorChar : public Iterator {
	private:
		Object_String *_pObj;
		int _cnt;
		String::const_iterator _pCur;
	public:
		IteratorChar(Object_String *pObj, int maxSplit);
		virtual ~IteratorChar();
		virtual bool Next(Signal sig, Value &value);
	};
	class IteratorSplit : public Iterator {
	private:
		Object_String *_pObj;
		String _sep;
		int _cnt;
		bool _ignoreCaseFlag;
		bool _doneFlag;
		String::const_iterator _pCur;
	public:
		IteratorSplit(Object_String *pObj,
						const char *sep, int maxSplit, bool ignoreCaseFlag);
		virtual ~IteratorSplit();
		virtual bool Next(Signal sig, Value &value);
	};
public:
	inline static Object_String *GetSelfObj(Context &context) {
		return dynamic_cast<Object_String *>(context.GetSelfObj());
	}
private:
	String _str;
public:
	inline Object_String(Class *pClass) : Object(pClass) {}
	inline Object_String(Class *pClass, const char *str) : Object(pClass), _str(str) {}
	inline Object_String(Class *pClass, const char *str, size_t len) :
											Object(pClass), _str(str, len) {}
	Object_String(const Object_String &obj);
	virtual ~Object_String();
	virtual Object *Clone() const;
	virtual Value GetByIndex(Signal sig, const Value &valueIdx);
	virtual void SetByIndex(Signal sig, const Value &valueIdx, const Value &value);
	virtual Iterator *CreateIterator(Signal sig);
	virtual String ToString(Signal sig, bool exprFlag);
	inline const char *GetString() const { return _str.c_str(); }
	inline const String &_GetString() const { return _str; }
};

}

#endif
