#ifndef __OBJECT_LIST_H__
#define __OBJECT_LIST_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_List
//-----------------------------------------------------------------------------
class Class_List : public Class {
public:
	Class_List(Class *pClassSuper, const Symbol *pSymbol);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

//-----------------------------------------------------------------------------
// Object_List
//-----------------------------------------------------------------------------
class Object_List : public Object {
public:
	class IteratorNormal : public Iterator {
	private:
		Object_List *_pObj;
		ValueList::const_iterator _pValue;
	public:
		inline IteratorNormal(Object_List *pObj) :
			Iterator(false), _pObj(pObj), _pValue(pObj->GetList().begin()) {}
		inline IteratorNormal(Object_List *pObj, size_t offset) :
			Iterator(false), _pObj(pObj), _pValue((offset < pObj->GetList().size())?
					pObj->GetList().begin() + offset : pObj->GetList().end()) {}
		virtual ~IteratorNormal();
		virtual bool Next(Signal sig, Value &value);
	};
	class IteratorReverse : public Iterator {
	private:
		Object_List *_pObj;
		ValueList::reverse_iterator _pValue;
	public:
		inline IteratorReverse(Object_List *pObj) :
			Iterator(false), _pObj(pObj), _pValue(pObj->GetList().rbegin()) {}
		virtual ~IteratorReverse();
		virtual bool Next(Signal sig, Value &value);
	};
	class IteratorRound : public Iterator {
	private:
		Object_List *_pObj;
		ValueList::iterator _pValue;
		int _cnt;
	public:
		inline IteratorRound(Object_List *pObj, int cnt) :
			Iterator(false), _pObj(pObj), _pValue(pObj->GetList().begin()), _cnt(cnt) {}
		virtual ~IteratorRound();
		virtual bool Next(Signal sig, Value &value);
	};
public:
	inline static Object_List *GetSelfObj(Context &context) {
		return dynamic_cast<Object_List *>(context.GetSelfObj());
	}
public:
	typedef std::vector<size_t> IndexList;
	class ValueVisitorEx : public ValueVisitor {
	private:
		Environment &_env;
		const ValueList &_valList;
		IndexList _indexList;
	public:
		inline ValueVisitorEx(Environment &env, const ValueList &valList) :
											_env(env), _valList(valList) {}
		virtual void Visit(Signal sig, const Value &value);
		inline IndexList &GetIndexList() { return _indexList; }
	};
public:
	class Constructor : public ConstructorBase {
	public:
		Constructor(Environment &env, const char *name = AScript_Symbol(List)->GetName());
		virtual Value DoEval(Environment &env, Signal sig, Context &context) const;
	};
private:
	ValueList _valList;
public:
	inline Object_List(Class *pClass) : Object(pClass) {}
	inline Object_List(Class *pClass, size_t n, const Value &value) :
									Object(pClass), _valList(n, value) {}
	inline Object_List(const Object_List &obj) :
									Object(obj), _valList(obj._valList) {}
	virtual bool IsList() const;
	virtual Object *Clone() const;
	inline ValueList &GetList() { return _valList; }
	inline const ValueList &GetList() const { return _valList; }
	virtual Value GetByIndex(Signal sig, const Value &valueIdx);
	virtual void SetByIndex(Signal sig, const Value &valueIdx, const Value &value);
	virtual Iterator *CreateIterator(Signal sig);
	virtual String ToString(Signal sig, bool exprFlag);
	static void DoPadding(Signal sig, ValueList &valList, const Value &value);
};

}

#endif
