#ifndef __OBJECT_FILE_H__
#define __OBJECT_FILE_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_File / Object_File
//-----------------------------------------------------------------------------
class Class_File : public Class {
public:
	Class_File(Class *pClassSuper, const Symbol *pSymbol);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class Object_File : public Object {
public:
	class IteratorLine : public Iterator {
	private:
		Object_File *_pObj;
		int _nLinesMax;
		bool _includeEOLFlag;
		int _nLines;
	public:
		inline IteratorLine(Object_File *pObj, int nLinesMax, bool includeEOLFlag) :
					Iterator(false), _pObj(pObj), _nLinesMax(nLinesMax),
					_includeEOLFlag(includeEOLFlag), _nLines(0) {}
		virtual ~IteratorLine();
		virtual bool Next(Signal sig, Value &value);
	};
public:
	inline static Object_File *GetSelfObj(Context &context) {
		return dynamic_cast<Object_File *>(context.GetSelfObj());
	}
public:
	class Constructor : public ConstructorBase {
	public:
		Constructor(Environment &env, const char *name = AScript_Symbol(File)->GetName());
		virtual Value DoEval(Environment &env, Signal sig, Context &context) const;
	};
private:
	File _file;
public:
	inline Object_File(Class *pClass) : Object(pClass) {}
	inline Object_File(const Object_File &obj) : Object(obj), _file(obj._file) {}
	virtual bool IsFile() const;
	virtual Object *Clone() const;
	inline File &GetFile() { return _file; }
	bool IsWritable(Signal sig);
	bool IsReadable(Signal sig);
	virtual Iterator *CreateIterator(Signal sig);
	virtual String ToString(Signal sig, bool exprFlag);
};

}

#endif
