#ifndef __OBJECT_DICT_H__
#define __OBJECT_DICT_H__

#include "Object.h"

namespace AScript {

//-----------------------------------------------------------------------------
// Class_Dict / Object_Dict
//-----------------------------------------------------------------------------
class Class_Dict : public Class {
public:
	Class_Dict(Class *pClassSuper, const Symbol *pSymbol);
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
};

class Object_Dict : public Object {
public:
	class IteratorKeys : public Iterator {
	private:
		Object_Dict *_pObj;
		ValueDict::const_iterator _pCur;
	public:
		IteratorKeys(Object_Dict *pObj);
		virtual ~IteratorKeys();
		virtual bool Next(Signal sig, Value &value);
	};
	class IteratorValues : public Iterator {
	private:
		Object_Dict *_pObj;
		ValueDict::const_iterator _pCur;
	public:
		IteratorValues(Object_Dict *pObj);
		virtual ~IteratorValues();
		virtual bool Next(Signal sig, Value &value);
	};
	class IteratorPairs : public Iterator {
	private:
		Object_Dict *_pObj;
		ValueDict::const_iterator _pCur;
	public:
		IteratorPairs(Object_Dict *pObj);
		virtual ~IteratorPairs();
		virtual bool Next(Signal sig, Value &value);
	};
public:
	inline static Object_Dict *GetSelfObj(Context &context) {
		return dynamic_cast<Object_Dict *>(context.GetSelfObj());
	}
public:
	class Constructor : public ConstructorBase {
	public:
		Constructor(Environment &env, const char *name = AScript_Symbol(Dict)->GetName());
		virtual Value DoEval(Environment &env, Signal sig, Context &context) const;
	};
private:
	ValueDict _valDict;
public:
	inline Object_Dict(Class *pClass) : Object(pClass) {}
	inline Object_Dict(const Object_Dict &obj) :
								Object(obj), _valDict(obj._valDict) {}
	virtual bool IsDict() const;
	virtual Object *Clone() const;
	inline ValueDict &GetDict() { return _valDict; }
	inline const ValueDict &GetDict() const { return _valDict; }
	virtual Value GetByIndex(Signal sig, const Value &valueIdx);
	virtual void SetByIndex(Signal sig, const Value &valueIdx, const Value &value);
	virtual Iterator *CreateIterator(Signal sig);
	virtual String ToString(Signal sig, bool exprFlag);
	const Value *Find(Signal sig, const Value &valueIdx) const;
	static void SetError_KeyNotFound(Signal sig, const Value &valueIdx);
};

}

#endif
