#ifndef __OBJECT_H__
#define __OBJECT_H__

#include "Common.h"
#include "Environment.h"
#include "Function.h"
#include "Iterator.h"

#define AScript_DeclareClass(name) \
class Class_##name : public Class {												\
public:																			\
	static Class_##name *_pInst;												\
private:																		\
	Class_##name(Class *pClassSuper, const Symbol *pSymbol);					\
public:																			\
	static Class_##name *GetInstance(Environment &env);							\
};																				\
Class_##name *Class_##name::_pInst = NULL;										\
Class_##name *Class_##name::GetInstance(Environment &env)						\
{																				\
	if (_pInst == NULL) {														\
		_pInst = new Class_##name(env.GetClass_Object(), Symbol::Add(#name));	\
	}																			\
	return _pInst;																\
}

#define AScript_ImplementClass(name) \
Class_##name::Class_##name(Class *pClassSuper, const Symbol *pSymbol) : Class(pClassSuper, pSymbol)

#define AScript_Class(name, env) \
Class_##name::GetInstance(env)

namespace AScript {

//-----------------------------------------------------------------------------
// ObjectBase
//-----------------------------------------------------------------------------
class ObjectBase : public Environment, public ICallable {
protected:
	int _cntRef;
protected:
	inline ObjectBase(const ObjectBase &obj) :
							Environment(obj), _cntRef(obj._cntRef) {}
	ObjectBase(Environment *pEnvOuter, EnvType envType);
public:
	virtual ~ObjectBase();
	bool BuildContent(Environment &env, Signal sig, const Expr_Block *pExprBlock,
									const SymbolSet *pSymbolsAssignable = NULL);
	inline int DecRef() { _cntRef--; return _cntRef; }
	inline int GetRefCnt() const { return _cntRef; }
	inline static void Delete(ObjectBase *pObj) {
		if (pObj != NULL && pObj->DecRef() <= 0) delete pObj;
	}
	virtual bool IsList() const;
	virtual bool IsDict() const;
	virtual bool IsFile() const;
	virtual bool IsExpr() const;
	virtual bool IsFunction() const;
	virtual bool IsWrappedMethod() const;
	virtual Iterator *CreateIterator(Signal sig);
	virtual Value Call(Environment &env, Signal sig, ContextExpr &contextExpr);
	virtual String ToString(Signal sig, bool exprFlag) = 0;
};

//-----------------------------------------------------------------------------
// Class
//-----------------------------------------------------------------------------
class Class : public ObjectBase {
public:
	class Constructor : public ConstructorBase {
	public:
		Constructor(Environment &env, const char *name = AScript_Symbol(Object)->GetName());
		virtual Value DoEval(Environment &env, Signal sig, Context &context) const;
	};
protected:
	const Symbol *_pSymbol;
	Class *_pClassSuper;
	Function *_pConstructor;
protected:
	inline Class(const Class &cls) : ObjectBase(cls),
		_pSymbol(cls._pSymbol), _pClassSuper(cls._pClassSuper), _pConstructor(NULL) {}
public:
	Class(Environment *pEnvOuter, const Symbol *pSymbol);
	virtual ~Class();
	virtual bool IsCustom() const;
	virtual bool IsClass() const;
	virtual Object *CreateDescendant(Environment &env, Signal sig, Class *pClass);
	void Prepare();
	inline Class *IncRef() { _cntRef++; return this; }
	inline bool IsAnonymous() const {
		return _pSymbol->IsIdentical(AScript_Symbol(_anonymous_));
	}
	inline void SetSymbol(const Symbol *pSymbol) { _pSymbol = pSymbol; }
	inline const char *GetName() const { return _pSymbol->GetName(); }
	inline Class *GetClassSuper() { return _pClassSuper; }
	inline void SetConstructor(Function *pConstructor) {
		_pConstructor = pConstructor;
	}
	inline Function *GetConstructor() { return _pConstructor; }
	virtual String ToString(Signal sig, bool exprFlag);
};

//-----------------------------------------------------------------------------
// Object
//-----------------------------------------------------------------------------
class Object : public ObjectBase {
protected:
	Class *_pClass;
protected:
	inline Object(const Object &obj) : ObjectBase(obj), _pClass(obj._pClass) {}
public:
	Object(Class *pClass);
	virtual ~Object();
	virtual Object *Clone() const;
	inline Object *IncRef() { _cntRef++; return this; }
	virtual bool IsObject() const;
	inline Class *GetClass() { return _pClass; }
	inline const Class *GetClass() const { return _pClass; }
	const char *GetClassName() const;
	virtual Value GetByIndex(Signal sig, const Value &valueIdx);
	virtual void SetByIndex(Signal sig, const Value &valueIdx, const Value &value);
	virtual Value EvalGetter(Signal sig, const Symbol *pSymbol, bool &evaluatedFlag);
	virtual Value EvalSetter(Signal sig, const Symbol *pSymbol,
							const Value &value, bool &evaluatedFlag);
	virtual String ToString(Signal sig, bool exprFlag);
	Value EvalMethod(Signal sig, const Symbol *pSymbol,
							const ValueList &valListArg, bool &evaluatedFlag);
};

}

#endif
