// OAL: OS Abstraction Layer
#ifndef __OAL_H__
#define __OAL_H__
#include "Common.h"

namespace AScript {
namespace OAL {

void rename(const char *src, const char *dst);
void remove(const char *pathName);
void Sleep(Number delay);

class Thread {
public:
	void Start();
	virtual void Run() = 0;
};

class Semaphore {
private:
#if defined(HAVE_WINDOWS_H)
	HANDLE _hMutex;
#else
#endif
public:
	Semaphore();
	~Semaphore();
	void Wait();
	void Release();
};

}
}

#endif
