// OAL: OS Abstraction Layer
#include "OAL.h"

namespace AScript {
namespace OAL {

#if defined(HAVE_WINDOWS_H)
//=============================================================================
// Windows
//=============================================================================
void rename(const char *src, const char *dst)
{
	::MoveFileEx(src, dst, MOVEFILE_REPLACE_EXISTING);
}

void remove(const char *pathName)
{
	::DeleteFile(pathName);
}

void Sleep(Number delay)
{
	::Sleep(static_cast<long>(delay * 1000));
}

//-----------------------------------------------------------------------------
// Thread
//-----------------------------------------------------------------------------
static DWORD WINAPI ThreadProc(LPVOID lpParameter)
{
	reinterpret_cast<Thread *>(lpParameter)->Run();
	return 0;
}

void Thread::Start()
{
	DWORD threadId;
	::CreateThread(NULL, 0, ThreadProc, this, 0, &threadId);
}

//-----------------------------------------------------------------------------
// Semaphore
//-----------------------------------------------------------------------------
Semaphore::Semaphore()
{
	_hMutex = ::CreateMutex(NULL, FALSE, NULL);
}

Semaphore::~Semaphore()
{
	::DeleteObject(_hMutex);
}

void Semaphore::Wait()
{
	::WaitForSingleObject(_hMutex, INFINITE);
}

void Semaphore::Release()
{
	::ReleaseMutex(_hMutex);
}

#else
//=============================================================================
// Linux
//=============================================================================

void rename(const char *src, const char *dst)
{
	::rename(src, dst);
}

void remove(const char *pathName)
{
	::unlink(pathName);
}

void Sleep(Number delay)
{
}

//-----------------------------------------------------------------------------
// Thread
//-----------------------------------------------------------------------------
void Thread::Start()
{
}

//-----------------------------------------------------------------------------
// Semaphore
//-----------------------------------------------------------------------------
Semaphore::Semaphore()
{
}

Semaphore::~Semaphore()
{
}

void Semaphore::Wait()
{
}

void Semaphore::Release()
{
}

#endif

}
}
