//-----------------------------------------------------------------------------
// AScript sys module
//-----------------------------------------------------------------------------
#include "Module_sys.h"
#include "Object_File.h"
#include "Object_DateTime.h"

AScript_BeginModule(sys)

//-----------------------------------------------------------------------------
// AScript module functions: sys
//-----------------------------------------------------------------------------
// sys.echo()
AScript_DeclareFunction(echo)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "flag", VTYPE_Boolean);
}

AScript_ImplementFunction(echo)
{
	env.SetEchoFlag(context.GetBoolean(0));
	return Value::Null;
}

// sys.exit(status?:number)
AScript_DeclareFunction(exit)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "status", VTYPE_Number, false, OCCUR_ZeroOrOnce);
}

AScript_ImplementFunction(exit)
{
	::exit(context.IsNumber(0)? static_cast<int>(context.GetNumber(0)) : 0);
	return Value::Null;
}

AScript_ModuleEntry()
{
	do {
		Value value;
		ValueList &valList = value.InitAsList(env);
		valList.push_back(Value(env, "."));
#if defined(HAVE_WINDOWS_H)
		valList.push_back(Value(env, File::GetBaseDir().c_str()));
		do {
			String dirName(File::GetBaseDir());
			dirName += File::Separator;
			dirName += "DLLs";
			valList.push_back(Value(env, dirName.c_str()));
		} while (0);
		do {
			String dirName(File::GetBaseDir());
			dirName += File::Separator;
			dirName += "Lib";
			valList.push_back(Value(env, dirName.c_str()));
		} while (0);
#endif
		const char *str = ::getenv("ASCRIPTPATH");
		if (str != NULL) {
			SplitPathList(env, str, valList);
		}
		env.AssignValue(Symbol::Add("path"), value, false);
	} while (0);
	do {
		Value value;
		value.InitAsFile(env)->GetFile().OpenStdin();
		env.AssignValue(Symbol::Add("stdin"), value, false);
	} while (0);
	do {
		Value value;
		value.InitAsFile(env)->GetFile().OpenStdout();
		env.AssignValue(Symbol::Add("stdout"), value, false);
	} while (0);
	do {
		Value value;
		value.InitAsFile(env)->GetFile().OpenStderr();
		env.AssignValue(Symbol::Add("stderr"), value, false);
	} while (0);
	AScript_AssignValue(Symbol::Add("ps1"), Value(env, ">>> "));
	AScript_AssignValue(Symbol::Add("ps2"), Value(env, "... "));
	AScript_AssignFunction(echo);
	AScript_AssignFunction(exit);
}

AScript_ModuleTerminate()
{
}

void Setup(Module *pModule, Signal sig, int argc, const char *argv[])
{
	Value value;
	ValueList &valList = value.InitAsList(*pModule);
	if (argc > 1) {
		valList.push_back(Value(*pModule, File::MakeAbsPath(argv[1], NULL).c_str()));
		for (int i = 2; i < argc; i++) {
			valList.push_back(Value(*pModule, argv[i]));
		}
	}
	pModule->AssignValue(Symbol::Add("argv"), value, false);
}

AScript_EndModule(sys)

AScript_DLLModuleEntry(sys)
