//-----------------------------------------------------------------------------
// AScript sample module
//-----------------------------------------------------------------------------
#include "Module.h"

AScript_BeginModule(sample)

AScript_DeclarePrivSymbol(hoge_symbol);

//-----------------------------------------------------------------------------
// AScript module functions: sample
//-----------------------------------------------------------------------------
// sample.skeleton()
AScript_DeclareFunction(skeleton)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
}

AScript_ImplementFunction(skeleton)
{
	return Value::Null;
}

// result = sample.adder(num1:number, num2:number)
AScript_DeclareFunction(adder)
{
	SetMode(RSLTMODE_Normal, MAP_Off, FLAT_Off);
	DeclareArg(env, "num1", VTYPE_Number);
	DeclareArg(env, "num2", VTYPE_Number);
}

AScript_ImplementFunction(adder)
{
	return Value(context.GetNumber(0) + context.GetNumber(1));
}

// result = sample.adder2(num1:number, num2:number):map
// automapping version of adder(). see differences in their implementations.
AScript_DeclareFunction(adder2)
{
	SetMode(RSLTMODE_Normal, MAP_On, FLAT_Off);
	DeclareArg(env, "num1", VTYPE_Number);
	DeclareArg(env, "num2", VTYPE_Number);
}

AScript_ImplementFunction(adder2)
{
	return Value(context.GetNumber(0) + context.GetNumber(1));
}

// Module entry
AScript_ModuleEntry()
{
	AScript_RealizePrivSymbol(hoge_symbol);
	AScript_AssignValue(Symbol::Add("foo"),
								Value(env, "a value in sample module"));
	AScript_AssignFunction(skeleton);
	AScript_AssignFunction(adder);
	AScript_AssignFunction(adder2);
}

AScript_ModuleTerminate()
{
}

AScript_EndModule(sample)

AScript_DLLModuleEntry(sample)
