#ifndef __COMMON_H__
#define __COMMON_H__

#if defined(HAVE_WINDOWS_H)
#include <windows.h>
#include <direct.h>		// getcwd()
#define DLLEXPORT __declspec(dllexport)
#else
#include "config.h"
#define DLLEXPORT
#endif

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <math.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <complex>
#include <vector>
#include <deque>
#include <list>
#include <map>
#include <set>
#include <memory>
#include <algorithm>

extern "C" {
#include "SFMT.h"
}

#define NUMBEROF(x) (sizeof(x) / sizeof(x[0]))

#define ChooseMin(a, b) (((a) < (b))? (a) : (b))

#define foreach(T, i, c) for (T::iterator i = (c).begin(); i != (c).end(); i++)
#define foreach_const(T, i, c) for (T::const_iterator i = (c).begin(); i != (c).end(); i++)
#define foreach_reverse(T, i, c) for (T::reverse_iterator i = (c).rbegin(); i != (c).rend(); i++)
#define foreach_const_reverse(T, i, c) for (T::const_reverse_iterator i = (c).rbegin(); i != (c).rend(); i++)

#ifdef DEBUG_ASCRIPT
#define DBG(x) x
#define DBGPARSER(x) x
#define ASSUME(env, x) if (!(x)) { env.Error(__FILE__, __LINE__, #x); }
#else
#define DBG(x)
#define DBGPARSER(x)
#define ASSUME(env, x) if (!(x)) { env.Error(__FILE__, __LINE__, #x); }
#endif

#define ERROREND(env, str) (env).Error(__FILE__, __LINE__, (str));

namespace AScript {

extern const int MAX_STACK_LEVEL;

//-----------------------------------------------------------------------------
// Simple type declarations
//-----------------------------------------------------------------------------
typedef double Number;
typedef std::complex<Number> Complex;
typedef std::basic_string<char> String;

typedef std::deque<String> StringDeque;

//-----------------------------------------------------------------------------
// OccurPattern
//-----------------------------------------------------------------------------
enum OccurPattern {
	OCCUR_Invalid,
	OCCUR_Zero,			// (none)
	OCCUR_Once,			// 1
	OCCUR_ZeroOrOnce,	// ?
	OCCUR_ZeroOrMore,	// *
	OCCUR_OnceOrMore,	// +
};

//-----------------------------------------------------------------------------
// RandomNumberGenerator
//-----------------------------------------------------------------------------
class RandomNumberGenerator {
public:
	inline int operator()(int n) {
		return static_cast<int>(::genrand_real2() * n);
	}
};

}
#endif
