/** @file	string.c
 *  @brief	string module
 *		This module is standard string library for kernel.
 *  Copyright (c) kaworu
 *  $Id: string.c,v 1.7 2003/11/21 07:24:11 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/10/20 update: $Date: 2003/11/21 07:24:11 $
 *  @version	$Revision: 1.7 $
 */
#define PUBLIC
#define PRIVATE	static
#include "types.h"

#undef	strcpy
#undef	strncpy
#undef	strcat
#undef	strcmp

/* work...
 * strcat	o
 * strcmp	o
 * strcpy	o
 * strlcat
 * strlcpy
 * strlen	o
 * strncmp
 * strncpy	o
 * strncat
 * strchr
 * strrchr
 * strstr
 * memset	x
 * memcpy
 */

/**
 * @brief	strcpy
 * @author	kaworu
 * @date	since: 2003/10/20
 * @param	dst [out]
 * @param	src [in]
 * @return	pointer of dst top
 */
PUBLIC char *
strcpy (char * __restrict dst, char * __restrict src)
{
	char	*r;

	for (r = dst; (*dst = *src) != '\0'; dst++, src++)
	{
		/* nothing */;
	}

	return (r);
}

/**
 * @brief	strncpy
 * @author	kaworu
 * @date	since: 2003/11/15
 * @param	dst [out]
 * @param	src [in]
 * @param	len [in]
 * @return	pointer of dst top
 */
PUBLIC char *
strncpy (char * __restrict dst, char * __restrict src, int len)
{
	char		*p;
	const char	*s;

#if 0
#define	assert	(void)0
/* null pointer check */
	assert (dst != NULL);
	assert (src != NULL);
#endif

	for (p = dst, s = src; (len != 0); len--)
	{
		if ( (*p++ = *s++) == 0)
		{
			/* NULL pad the remaining buffer */
			while (--len != 0)
			{
				*p++ = 0;
			}
			break;
		}
	}
	
	return (dst);
}
/**
 * @brief	strcat
 * @author	kaworu
 * @date	since: 2003/10/20 update: 2003/11/15
 * @param	dst [out]
 * @param	src [in]
 * @return	pointer of dst top
 */
PUBLIC char *
strcat (char * __restrict dst, char * __restrict src)
{
	register char	*r;

	for (r = dst; *dst; dst++)
	{
		/* nothing */
	}

	for ( ; (*dst = *src) != '\0'; dst++, src++)
	{
		/* nothing */
	}

	return (r);
}

/**
 * @brief	strcmp
 * @author	kaworu
 * @date	since: 2003/10/20 update: 2003/11/15
 * @param	s1 [in] string
 * @param	s2 [in] s2 is another string
 * @return	
 */
PUBLIC int
strcmp (char * __restrict s1, char * __restrict s2)
{

	for ( ; (*s1 == *s2); s1++, s2++)
	{
		if (*s1 == '\0')
		{
			return (0);
		}
	}

	return ( (int) (*s1 - *s2) );
#if 0
	register int	i;

	for ( ; ; s1++, s2++)
	{
		i = (int) (*s1 - *s2);
		if ( (i != 0) || (*s1 == '\0') )
		{
			break;
		}
	}
	return (i);
#endif
}

/**
 * @brief	strlen
 * @author	kaworu
 * @date	since: 2003/10/20
 * @param	str [in] string
 * @return	
 */
PUBLIC int
strlen (const char *str)
{
	register const char	*s;

	for (s = str; *s; s++)
	{
		/* nothing */
	}

	return (s - str);
}

/**
 * @brief	memset
 *		This is test version.
 * @author	kaworu
 * @date	since: 2003/11/17 update: 2003/11/20
 * @param	dst [out]
 * @param	c [in]
 * @param	len [in]
 * @return	pointer of dst top
 */
PUBLIC void *
memset (void *dst, int c, uint len)
{
	char	*p;

	p = (char *) dst;

	while (len-- > 0)
	{
		*p++ = (char) c;
	}

	return (dst);
}

/**
 * @brief	memcpy
 *		This is test version.
 *		ɥ쥹 dst Фơɥ쥹 src 
 *		len ǻꤵ줿ǡ򥳥ԡ롣
 * @author	kaworu
 * @date	since: 2003/11/20 update: 2003/11/20
 * @param	dst [out]
 * @param	src [in]
 * @param	len [in]
 * @return	pointer of dst top
 */
PUBLIC void *
memcpy (void * __restrict dst, void * __restrict src, uint len)
{
	char	*d, *s;

	for (d = dst, s = src; len > 0; len--)
	{
		*d++ = *s++;
	}

	return (dst);
}

