/** @file	__assert.c
 *  @brief	__assert module
 *		This module is __assert for kernel.
 *  Copyright (c) kaworu
 *  $Id: __assert.c,v 1.1 2003/11/30 16:46:43 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/12/01 update: $Date: 2003/11/30 16:46:43 $
 *  @version	$Revision: 1.1 $
 */

#include "std.h"
#include "stdkern.h"

PUBLIC void
__assert (const char *func,	const char *file,
	  const int line,	const char *exp)
{
	const char * const fmt =
		"kernel: assertion, file: %s, line %d, func: %s, %s:failed";

#if 0
	panic (fmt, file, line, func, exp);
#else
	(void) kprintf (fmt, file, line, func, exp);
	HALT;
#endif
	/* NOTREACHED */
	return;
}
