/** @file	tss.h
 *  @brief	intel 386 TSS
 *  Copyright (c) kaworu
 *  $Id: tss.h,v 1.1 2003/12/05 09:43:06 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/12/05 update:$
 *  @version	$Revision: 1.1 $
 */

#ifndef TSS_H
#define TSS_H

/*
 * intel i386 context data type
 * Task State Segment
 */

struct tss
{
	int	link;
	int	esp0;
	int	ss0;
	int	esp1;
	int	ss1;
	int	esp2;
	int	ss2;
	int	cr3;
	int	eip;
	int	eflags;
	int	eax,
	int	ecx,
	int	edx,
	int	ebx,
	int	esp,
	int	ebp,
	int	esi,
	int	edi,
	int	es,
	int	cs,
	int	ss,
	int	ds,
	int	fs,
	int	gs,
	int	ldt,
	int	iomap;
};

#endif /* TSS_H */
