/** @file	stdkern.h
 *  @brief	standerd kernel module header
 *  Copyright (c) kaworu
 *  $Id: stdkern.h,v 1.3 2003/12/05 12:11:01 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/12/01 update: $Date: 2003/12/05 12:11:01 $
 *  @version	$Revision: 1.3 $
 */

#ifndef STDKERN_H
#define STDKERN_H

#include "std.h"
/* kprintf.c */
PUBLIC int kprintf (const char *fmt, ...);

/* macro */
#define cli()	__asm__ volatile ("cli")
#define sti()	__asm__ volatile ("sti")


/* debug */
#ifdef KDEBUG
#define trace()		(void)kprintf("%s\n", __func__)
#define tracep(s)	do {			\
	(void)kprintf("%s: ", __func__);	\
	(void)kprintf s;			\
	(void)kprintf("\n");			\
}while (0)
#else  /* not KDEBUG */
#define trace()		(void)0
#define tracep(s)	(void)0
#endif /* not KDEBUG */

#endif
