/** @file	desc.h
 *  @brief	desc
 *  Copyright (c) kaworu
 *  $Id: desc.h,v 1.3 2003/12/05 18:01:20 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/11/16 update: $Date: 2003/12/05 18:01:20 $
 *  @version	$Revision: 1.3 $
 */

#ifndef DESC_H
#define DESC_H

#define GDT_ENTRY_MAX	8192
#define GDT_ENTRY_MIN	512

enum
{
	TYPE_RESERVED0	= 0,	/* 0 */
	TYPE_TSS16,		/* 1 */
	TYPE_LDT,		/* 2 */
	TYPE_TSS16BUSY,		/* 3 */
	TYPE_CALLGATE16,	/* 4 */
	TYPE_TASKGATE,		/* 5 */
	TYPE_INTGATE,		/* 6 */
	TYPE_TRAPGATE16,	/* 7 */
	TYPE_RESERVED8,		/* 8 */
	TYPE_TSS32,		/* 9 */
	TYPE_RESERVED10,	/* 10 */
	TYPE_TSS32BUSY,		/* 11 */
	TYPE_CALLGATE32,	/* 12 */
	TYPE_RESERVED13,	/* 13 */
	TYPE_INTGATE32,		/* 14 */
	TYPE_TRAPGATE32		/* 15 */
};

/*
 * region descriptor for gdt/idt table
 * sizeof 6byte
 */
#pragma	pack(2)
struct rdesc
{
	unsigned long	limit	:16;	/* segment extent	*/
	unsigned long	base	:32;	/* base address		*/
};
#pragma	pack()

struct desc
{
	unsigned long	addr;
	unsigned long	dpl;
};

/*
 * segment descriptor
 * sizeof 8byte
 */
struct sdesc
{
	unsigned lolimit:16;
#if 1
	unsigned lobase	:24;
#else
	unsigned lobase	:16;
	unsigned mibase	:8;
#endif
	unsigned type	:4;
	unsigned s	:1;
	unsigned dpl	:2;
	unsigned p	:1;
	unsigned hilimit:4;
	unsigned avl	:1;
	unsigned res	:1;
	unsigned db	:1;
	unsigned g	:1;
	unsigned hibase	:8;
};

struct descriptor
{
	
};

#endif
