/** @file	boot.h
 *  @brief	boot
 *  Copyright (c) kaworu
 *  $Id: boot.h,v 1.4 2003/12/06 08:25:51 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/06/21 update: $Date: 2003/12/06 08:25:51 $
 *  @version	$Revision: 1.4 $
 */

/*
how to use memory

0x07c00		boot
0x90000		wake
0x90200		standup
 */

#ifndef BOOT_H
#define BOOT_H
#if 1
#define	BOOTSEG		0x07c0
#define	INITSEG		(0x9000-0x0020)	/* 8980 */
//#define	SETUPSEG	0x9000
#define WAKESEG		0x9000
#define DUMMYSEG	0x9040
#endif

#if 0
#define	BOOTSEG		0x07c0
#define	INITSEG		0x9000
#define	SETUPSEG	0x9020
#define WAKESEG		0x9020
#define DUMMYSEG	0x9060
#endif
#define PROG1SEG	0x07c0
#define SYSSEG		0x00100000

#define DELTA_INITSEG	SETUPSEG - INITSEG	 /* 0x0020 */
#define SETUPSECTS	0x04

/*
#define CODE16		asm (".code16gcc")
#define CODE32		asm (".code32gcc")
*/
#define __KERNEL_CS	0x08
#define __KERNEL_DS	0x10
#define __KERNEL_SS	0x18
#define __KERNEL_IDT	0x48

#endif
