/** @file	assert.h
 *  @brief	assert
 *  Copyright (c) kaworu
 *  $Id: assert.h,v 1.1 2003/11/30 16:44:10 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/11/30 update: $Date: 2003/11/30 16:44:10 $
 *  @version	$Revision: 1.1 $
 */
#ifndef ASSERT_H
#define ASSERT_H

#ifdef NODEBUG
#define assert(exp)	((void)0)
#else /* not NODEBUG */
#define assert(exp)	((exp) ? (void)0 : __assert(	__func__,__FILE__, \
							__LINE__, #exp))
#endif /* not NODEBUG */

#ifndef PUBLIC
#define PUBLIC
#endif /* PUBLIC */

PUBLIC void __assert (const char *func, const char *file,
		      const int line, const char *exp);
#endif
