/** @file	wake.S
 *  @brief	wake for boot
 *  Copyright (c) kaworu
 *  $Id: wake.S,v 1.26 2003/11/29 18:36:24 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/06/21 update: $Date: 2003/11/29 18:36:24 $
 *  @version	$Revision: 1.26 $
 */

#include "boot.h"

	.code16gcc		// This runs in real mode
	.text
	.global		wake
	.global		putx
	.global		dummy

wake:
	pushl	%ebp
	movl	%esp,	%ebp	// stack

	movw	$WAKESEG,%ax
	movw	%ax,	%es	// Address
	movw	%ax,	%ds	// data
	//xorw	%ax,	%ax	// Zero
	movw	%ax,	%ss	// stack

	movl	$phase01,	%esi
	call	putx

	call	fd_stop
	call	mouse_reset
	call	mouse_cursor_show
	call	mouse_set_cursor_place
	call	mouse_set_cursor_text

/*
 * 1M ΰ kernel 򥳥ԡ
 */
copy_kernel:
	// 0x0200 -> if kernek size is 512 byte.
	movw	$0x8000,	%cx	// number of words to copy(max 8000h)
	movw	$boot_gdt,	%si	// global descriptor table for this copy
	movw	$0x8700,	%ax	// copy exitended memory
	int	$0x15
	jc	copy_kernel_fail

nmi:					// Disable NMI
	cli				// Disable all interrupts
	movb	$0x80,	%al
	outb	%al,	$0x70
rtop:					// Real To Protect
#if 0
	lidt	idt_48				// Load idt_48
	xorl	%eax,	%eax			// Zero
	movw	%cs,	%ax
	movw	%ax,	%dx
	xorl	%eax,	%eax			// Zero
	movw	%ds,	%ax			// 
	shll	$4,	%eax			//
	//shll	$16,	%eax			// 
	addl	$gdt,	%eax
	//addl	$gdt00,	%eax
	movl	%eax,	(gdt_48 + 2)		// %ds:gdt
	lgdt	gdt_48				// Load gdt_48
#else
	lidt	idt_48				// Load idt_48
	xorl	%eax,	%eax			// Zero
	movw	%ds,	%ax			// ax = ds
	shll	$4,	%eax			// eax <<= 4
	addl	$gdt,	%eax			// eax += $gdt
	movl	%eax,	(gdt_48 + 2)		// %ds:gdt
	lgdt	gdt_48				// Load gdt_48
#endif
	// possible coprocessor is properly reset
	/*
	xorw	%ax,	%ax
	outb	%al,	$0xf0
	call	delay

	outb	%al,	$0xfa
	call	delay

	movb	$0xff,	%al
	outb	%al,	$0xa1
	call	delay
	movb	$0xfb,	%al
	outb	%al,	$0x21
	*/
	# cr0(protect mode)
#if	1
	movl	%cr0,	%eax
	orl	$0x1,	%eax
	movl	%eax,	%cr0
#else
	movw	$1,	%ax	// Protected mode (PE) bit
	lmsw	%ax
#endif
	jmp	flush_pipeline

flush_pipeline:

	xorw	%bx,	%bx			// Zero
	xorl	%esi,	%esi			// Zero
	movw	%cs,	%si
	subw	$DUMMYSEG-WAKESEG,	%si
	shll	$4,	%esi
#if	1
	.code32
//	movl	$0x18,	%eax
	movl	$__KERNEL_SS,	%eax
	movw	%ax,	%ss
//	movl	$0x10,	%eax
	movl	$__KERNEL_DS,	%eax
	movw	%ax,	%ds
	movw	%ax,	%es
	movw	%ax,	%fs
	movw	%ax,	%gs
	.code16gcc
	.byte	0x66,	0xea			//
code32:
#if 1
	.long	0x100000
	.word	0x08
#else
	.long	0x90400 			//.long	0x0090400
	.word	0x08
#endif
set_cs:
	/*
	movw	$0x10,	%ax
	movw	%ax,	%ds
	movw	%ax,	%es
	movw	$0x18,	%ax
	movw	%ax,	%ss
	movl	1024*1024*2,	%esp
	pushl	%eax
	jmp	0x400
	*/
#else
.code32
	.byte	0x66
	ljmp	$0x10,	$0x9040
.code16gcc
#endif

	//ljmp	$DUMMYSEG,	$0x000
	movl	$msg,	%esi
	call	putx
loop:
	jmp loop		// forever

// putx (char *p)
putx:
	lodsb
	cmpb	$0,		%al
	je	.P1

	movb	$0x0e,		%ah
	movw	$0x07,		%bx
	int	$0x10

	jne	putx
.P1:
	ret

dummy:
	pushl	%ebp
	movl	%esp,	%ebp
	subl	$4,	%esp
	movl	8(%ebp),%eax
	#movb	$'x',	%al
	movb	$0x0e,	%ah
	movw	$0x07,	%bx
	int	$0x10

	leave
	ret

/*
 * Stop the FD motor.
 */
fd_stop:
#if 1
	xorw	%ax,	%ax	# Zero
	xorb	%dl,	%dl	# Zero
	int	$0x13
#else
	movw	$0x3f2,	%dx
	xorb	%al,	%al	# Zero
	outb	%al,	%dx
#endif
	ret

mouse_reset:
	xorw	%ax,	%ax
	int	$0x33
	ret
mouse_cursor_show:
	xorw	$0x01,	%ax
	int	$0x33
	ret
mouse_set_cursor_place:
	movw	$0x04,	%ax	// number
	movw	$0x00,	%cx	// x
	movw	$0x00,	%dx	// y
	int	$0x33
	ret
mouse_set_cursor_text:
	movw	$0x0a,	%ax	// 10
	movw	$0x01,	%bx	// Hardware Cursor(1) / Sofrware Cursor(0)
	movw	$0x00,	%cx
	movw	$0x00,	%dx
	int	$0x33
	ret

delay:
	outb	%al,	$0x80
	ret

copy_kernel_fail:
	movl	$cpfail,	%esi
	call	putx
die:
	loop	die

cpfail:
	.ascii	"copy fail"
	.byte	0
// Descriptor table
gdt:				// global descriptor table
//	.word	0, 0, 0, 0	// dummy
gdt00:	// unused: Null entry
	.word	0x0		// Segment Limit L
	.word	0x0		// Base Address L
	.word	0x0		// type, baseM
	.word	0x0		// limitH, baseH

	// Segment 08:	Code Segment
gdt08:
	.word	0xffff		// 4GB
	.word	0x0		// base address = 0
	.word	0x9a00		// code read/exec (Type:Code)
	.word	0x00cf		// granularity = 4096, 386

	// Segment 10:	Data Segment
gdt10:
	.word	0xffff		// 4GB
	.word	0		// base address = 0
	.word	0x9200		// code read/exec (Type:data)
	.word	0x00cf		// granularity = 4096, 386
	// Segment 18: Stack Segment
gdt18:
	.word	0x0000		// segment limit 15:00
	.word	0x0000		// base address 15:00
	.word	0x9200		// P:1/DPL:2/S:1/TYPE:4/base:23:16
	.word	0x00ff		// base:31:24/G:1/DB:1/0/AVL:1/seg limit:4

idt_48:				// interrupt descriptor table
	.word	0		// idt limit = 0
	.word	0,	0	// idt base = 0L

gdt_48:				// global descriptor table
	.word	0x8000		// gdt limit=2048, 256 GDT entries
	.word	0,	0	// gdt base (filled in later)

/*
 * Format of global descriptor table (for int 15h ax=87h)
 * Offset	size
 * 00h		16byte	all zero (used by bios)
 *
 * 10h		word	source segment length in bytes
 * 12h		3byte	24bit linear source address, low byte first
 * 15h		byte	source segment access rights (93h)
 * 16h		word	(286) zero
 *
 * 18h		word	destination segment length in bytes
 * 1ah		3byte	24bit linear destination address, low byte first
 * 1dh		byte	destination segment access rights (93h)
 * 1eh		word	(286) zero
 * 20h		16byte	all zero (used by bios)
 */

boot_gdt:
	.word	0, 0, 0, 0
	.word	0, 0, 0, 0
boot_src:
	.word	0xffff
	.byte	0x00, 0x04, 0x09	// 0x090400
	.byte	0x93
	.word	0
boot_des:
	.word	0xffff
	.byte	0, 0, 0x10		// 0x100000
	.byte	0x93
	.word	0

	.word	0, 0, 0, 0
	.word	0, 0, 0, 0

phase01:
        .ascii	"Phase01: wake\n\r"
	.byte	0
msg_a20_done:
	.ascii	" Protect mode\n\r\0"
msg_a20_dead:
	.ascii	" Can't switch protect mode\0"
msg:
	.ascii "xxx"
	.byte 0

