/** @file	rtc.c
 *  @brief	Real Time Clock
 *  Copyright (c) kaworu
 *  $Id: rtc.c,v 1.7 2003/12/05 18:00:20 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2002/12/03 update:$
 *  @version	$Revision: 1.7 $
 */
asm (".code32");
#include "std.h"
#include "stdkern.h"
#include "io.h"

/*
 * RTC: Target register 70/71h
 */
#define RTC_ADDR	0x70	/* NMI mask/RTC register */
#define RTC_DATA	0x71	/* RTC data	*/

/*                      Index      Name                 */
#define RTC_SEC		0x00	/* Seconds		*/
#define RTC_SECALARM	0x01	/* Seconds Alarm	*/
#define RTC_MIN		0x02	/* Minutes		*/
#define RTC_MINALARM	0x03	/* Minutes Alarm	*/
#define RTC_HOUR	0x04	/* Hours		*/
#define RTC_HOURALARM	0x05	/* Hours Alarm		*/
#define RTC_WDAY	0x06	/* Day of Week		*/
#define RTC_DAY		0x07	/* Day of Month		*/
#define RTC_MONTH	0x08	/* Month		*/
#define RTC_YEAR	0x09	/* Year			*/
#define RTC_REGA	0x0A	/* Register A		*/
#define RTC_REGB	0x0B	/* Register B		*/
#define RTC_REGC	0x0C	/* Register C		*/
#define RTC_REGD	0x0D	/* Register D		*/

#define RTC_CENTURY	0x32	/* current century	*/

#define TIMER_FREQ	1193182

#if 0
/* äƤ... */
#define RTC_DIVIDER	0x06	/* 0110 = 1.024kHz, 976.562 */
#define RTC_NOPROF	0x20
#endif

PRIVATE uint	timer_freq	= TIMER_FREQ;
PRIVATE byte	rtc_rega;
PRIVATE byte	rtc_regb;


/*
 * time struct
 */
struct tm
{
#if 0
	byte	sec;
	byte	min;
	byte	hour;
	byte	wday;
	byte	day;
	byte	month;
	byte	year;
#else
	int	sec;
	int	min;
	int	hour;
	int	wday;
	int	day;
	int	month;
	int	year;
#endif
#if 0
	char	*zone;		/* time zone (now unused) */
#endif
};

/**
 * @breif	rtc_get_data
 * @author	kaworu
 * @date	since: 2003/12/03
 * @param	reg [in]
 * @return	Data corresponding to reg
 */
PRIVATE INLINE byte
rtc_get_data (byte reg)
{
	byte	data;

	cli ();
	inb (0x84);
	outb (RTC_ADDR, reg & 0xff);
	inb (0x84);
	data = inb (RTC_DATA);
	inb (0x84);
	//sti ();

	return (data);
}

/**
 * @breif	rtc_get_data
 * @author	kaworu
 * @date	since: 2003/12/05
 * @param	reg [in]
 * @param	val [in]
 */
PRIVATE INLINE void
rtc_set_data (byte reg, byte val)
{

	outb (RTC_ADDR, reg);
	outb (RTC_DATA, val);

	return;
}
/**
 * @breif	rtc_get_time
 *		֤뤿˲ɤɬפ
 * @author	kaworu
 * @date	since: 2003/12/03
 * @param	think now
 * @return	int
 */
PUBLIC int
rtc_get_time ()
{
	struct tm t;

	t.sec	= rtc_get_data (RTC_SEC);
	t.min	= rtc_get_data (RTC_MIN);
	t.hour	= rtc_get_data (RTC_HOUR);
	t.wday	= rtc_get_data (RTC_WDAY);
	t.day	= rtc_get_data (RTC_DAY);
	t.month	= rtc_get_data (RTC_MONTH);
	t.year	= rtc_get_data (RTC_YEAR) + rtc_get_data (RTC_CENTURY) * 100;;

	if (t.sec >= 60)
	{
		t.sec %= 60;
		t.min++;
	}
	if (t.min == 60)
	{
		t.min = 0;
		t.hour++;
	}
	if (t.hour == 24)
	{
		t.hour = 0;
	}

	(void) kprintf (
		"now: %d/%d/%d:%d: %d:%d:%d",
		(int) t.year,
		(int) t.month - 6,
		(int) t.day,
		(int) t.wday,
		(int) t.hour,
		(int) t.min,
		(int) t.sec
		);
	outb (RTC_ADDR, RTC_REGA);
	kprintf (", %d", inb (RTC_DATA) );
	outb (RTC_ADDR, RTC_REGB);
	kprintf (", %d", inb (RTC_DATA) );
	outb (RTC_ADDR, RTC_REGC);
	kprintf (", %d", inb (RTC_DATA) );
	outb (RTC_ADDR, RTC_REGD);
	kprintf (", %d", inb (RTC_DATA) );

	return (0);
}
