/** @file	pic
 *  @brief	pic
 *  Copyright (c) kaworu
 *  $Id: pic.c,v 1.1 2003/12/05 09:26:24 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/12/05 update: $Date: 2003/12/05 09:26:24 $
 *  @version	$Revision: 1.1 $
 */
asm (".code32");

#include "std.h"
#include "stdkern.h"
#include "io.h"

/**
 * @breif	i8259a_init
 * @author	kaworu
 * @date	since: 2003/12/05
 */
void
i8259a_init ()
{

	/* master */
	outb (0x20, 0x11);	/* ICW1 */
	outb (0x21, 0x20);	/* ICW2 0x20=32 */
	outb (0x21, 0x04);	/* ICW3 */
	outb (0x21, 0x01);	/* ICW4 */

	/* slave */
	outb (0xa0, 0x11);	/* ICW1 */
	outb (0xa1, 0x28);	/* ICW2 0x28=40 */
	outb (0xa1, 0x04);	/* ICW3 */
	outb (0xa1, 0x01);	/* ICW4 */

	/* timer setting 10ms */
	{
		int	timer = 10 * 1193181 / 1000;

		outb (0x43, 0x36);
		outb (0x40, timer & 0xff);
		outb (0x40, timer >> 8);
	}

	return;
}
