/** @file	kprintf.c
 *  @brief	kprintf module
 *  Copyright (c) kaworu
 *  $Id: kprintf.c,v 1.8 2003/11/30 16:48:07 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/04/18 update: $Date: 2003/11/30 16:48:07 $
 *  @version	$Revision: 1.8 $
 */

asm (".code32");
#include "std.h"

PUBLIC int kprintf (const char *fmt, ...);
int pubchar (const char c);
void itoa (char *buf, int val, int base);

//int console_write (const char c);

int
putchar (const char c)
{
	int ret;

	switch (c)
	{
	case '\r':
		ret = console_write ('\n');
		ret = console_write ('\r');
		break;
	case '\b':
		ret = console_write ('\b');
		ret = console_write (' ');
		ret = console_write ('\b');
		break;
	default:
		ret = console_write (c);
		break;
	}

	return (ret);
}


int
console_write (const char c)
//putchar (const char c)
{
	int ret;

	asm volatile (
		"int $0x10" :
		"=a" (ret):
		"a" (0x0e00 | (c & 0xff)),
		"b" (7)
		);

	return (ret);
}


void
itoa (char *buf, int val, int base)
{
	char	*p, *h, *t;
	char	tmp;
	//static char	*s = "0123456789ABCDEF";

	p = buf;
	do {
		*p++ = "0123456789ABCDEF" [val % base];
		//*p++ = s [val % base];
	} while (val /= base);

	*p = '\0';
	h = p - 1;
	t = buf;

	while (t < h)
	{
		tmp = *t;
		*t++ = *h;
		*h-- = tmp;
	}
}


#define putchar	putc

int
kputs (const char *str)
{
	char *p;

	for (p = str; *p != '\0'; )
	{
		putchar (*p++);
	}

	return (p - str);
}

PUBLIC int
kprintf (const char *fmt, ...)
{
	int	ret;
	int	val;
	char	c;
	char	ch;
	char	*s, *str;
	static char	buf[32];	//! static դʤȤưʤ
	unsigned int *arg;
	char *t;

	arg = (unsigned int *) & fmt;
	arg++;

	ret = 0;

	for (s = (char *) fmt; *s; )
	{
		if (*s == '%')
		{
			switch (*++s)
			{
			case 'c':
				ch = *( (char *) arg++);
				putchar (ch);
				ret++;
				break;

			case 's':
				str = *( (char **) arg++);
				while ( (ch = *str++))
				{
					putchar (ch);
					ret++;
				}
				break;
			case 'd':
				val = *( (int *) arg++);
				itoa (buf, val, 10);
				str = buf;

				while ( (ch = *str++))
				{
					putchar (ch);
					ret++;
				}
				break;
			case 'x':
				val = *( (int *) arg++);
				itoa (buf, val, 16);
				str = buf;

				while ( (ch = *str++))
				{
					putchar (ch);
					ret++;
				}
				break;
			case '%':
				putchar ('%');
				ret++;
			default:
				break;
			}
			s++;
		}
//		else if (*s == '\\')
		else
		{
			switch (*s)
			{
			case '\a':
				putchar ('\a');
				break;
			case '\t':
				putchar (' '); putchar (' ');
				putchar (' '); putchar (' ');
				putchar (' '); putchar (' ');
				putchar (' '); putchar (' ');
				ret++;
				break;
			case '\r':
				putchar ('\r');
				ret++;
				break;
			case '\n':
				putchar ('\r');
				putchar ('\n');
				ret++;
				break;
			case '\b':
			default:
				putchar (*s);
				ret++;
				break;
			}
			s++;
		}
	}

	return (ret);
}

#if 0
int
xprintf (const char *fmt, ...)
{
	int	ret;
	int	val;
	char	c;
	char	ch;
	char	*s, *str;
	char	buf[32];
	unsigned int *arg;
	char *t;

	arg = (unsigned int *) & fmt;
	arg++;

	ret = 0;
	for (s = (char *) fmt; *s; )
	{
		if (*s == '%')
		{
			switch (*++s)
			{
			case 'c':
				ch = *( (char *) arg++);
				putchar (ch);
				ret++;
				break;

			case 's':
				str = *( (char **) arg++);
				while ( (ch = *str++))
				{
					putchar (ch);
					ret++;
				}
				break;
			case 'd':
				val = *( (int *) arg++);
				itoa (buf, val, 10);
				str = buf;

				while ( (ch = *str++))
				{
					putchar (ch);
					ret++;
				}
				break;
			case 'x':
				val = *( (int *) arg++);
				itoa (buf, val, 16);
				str = buf;

				while ( (ch = *str++))
				{
					putchar (ch);
					ret++;
				}
				break;
			case '%':
				putchar ('%');
				ret++;
			default:
				break;
			}
			s++;
		}
//		else if (*s == '\\')
		else
		{
			switch (*s)
			{
			case '\a':
				putchar ('\a');
				break;
			case '\t':
				putchar (' '); putchar (' ');
				putchar (' '); putchar (' ');
				putchar (' '); putchar (' ');
				putchar (' '); putchar (' ');
				ret++;
				break;
			case '\r':
				putchar ('\r');
				ret++;
				break;
			case '\n':
				putchar ('\r');
				putchar ('\n');
				ret++;
				break;
			default:
				putchar (*s);
				ret++;
				break;
			}
			s++;
		}
	}

	return (ret);
}
#endif
