/** @file	kernel.ls
 *  @brief	linker script for kernel
 *  Copyright (c) kaworu
 *  $Id: kernel.ls,v 1.5 2003/12/03 03:41:07 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/06/21 update: $Date: 2003/12/03 03:41:07 $
 *  @version	$Revision: 1.5 $
 */
OUTPUT_FORMAT("binary")			/* We want raw binary image */
OUTPUT_ARCH(i386)

/* Define memory layout */
/*
MEMORY {
	body : org =   0, len = 1024
}
*/

/*  . = 0x100000;*/
/* Specify input and output sections */
SECTIONS {
	. = 0x100000;
	.text   : { *(.text)	}	/* Executable codes 	*/
	.rodata : { *(.rodata*)	}	/* Constant data (R/O) 	*/
	.data   : { *(.data)	}   	/* Initialized data 	*/
	__bss_start = .;		/* BSS */
	.bss    : { *(.bss)	}    	/* Uninitialized data 	*/
	__bss_end = .;
}

/*
SECTIONS {
  .text   : { *(.text) }   > body
  .rodata : { *(.rodata*) } > body
  .data   : { *(.data) }   > body
  .bss    : { *(.bss) }    > body
 }
*/
