/** @file	io.c
 *  @brief	input/output
 *  Copyright (c) kaworu
 *  $Id: io.c,v 1.4 2003/12/04 17:08:53 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2002/12/01 update: $Date: 2003/12/04 17:08:53 $
 *  @version	$Revision: 1.4 $
 */
asm (".code32");
#include "std.h"

/**
 * @breif	outb - output byte(8bit)
 * @author	kaworu
 * @date	since: 2003/12/01
 * @param	port [in]
 * @param	value [in]
 * @return	none
 */
PUBLIC INLINE void
outb (int port, byte value)
{
#if 0
	unsigned char al = value;
	unsigned short dx = port;

	asm volatile ("outb %0,%1":
			/* no output */:
			"a" (al),
			"id" (dx)
			);
#else
	__asm__ volatile ("outb %b0,%1":		/* outb %ax, %dx */
			/* no output */:
			"a" ( (byte) value),		/* ax */
			"Nd" ( (unsigned short) port)	/* dx */
//			"id" ( (unsigned short) port)	/* dx */
			);
#endif

	return;
}

/**
 * @breif	intb - input byte
 * 		input 8bit(1byteϤ)
 * @author	kaworu
 * @date	since: 2003/12/02
 * @param	port [in]
 * @return	data
 */
PUBLIC INLINE byte
inb (uint port)
{
	byte	data;

	__asm__ volatile (
		"inb %1, %0":			/* inb %dx, %al */
		"=a" (data):			/* al */
		"id" ( (ushort) port) 		/* dx */
		);

	return (data);
}
