/** @file	idt.c
 *  @brief	idt
 *  Copyright (c) kaworu
 *  $Id: idt.c,v 1.9 2003/12/05 18:04:01 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2002/11/15 update: $Date: 2003/12/05 18:04:01 $
 *  @version	$Revision: 1.9 $
 */
asm (".code32");
#include "std.h"
#include "stdkern.h"
#include "boot.h"
#include "desc.h"

#define IDT_TOTAL	256
#define IDT_TABLE_SIZE	(IDT_TOTAL * 2)

#define ATTR(sec) __attribute__( (section(#sec),aligned(1)))

#ifndef LINT
PUBLIC long	idt_table [ IDT_TABLE_SIZE ] ATTR(.data);
#else
PUBLIC long	idt_table [ IDT_TABLE_SIZE ];
#endif

struct rdesc	r_idt;

/**
 * @breif	lidt
 * @author	kaworu
 * @date	since: 2003/12/05
 */
PUBLIC void
lidt (struct rdesc *idtr)
{

	kprintf ("%s: %d\n", __func__, idtr);

	__asm__ volatile (
		"lidt (%0)":
		/* no output */:
		"r" (idtr)
		);

	return;
}

/**
 * @breif	int_dummy
 * @author	kaworu
 * @date	since: 2003/11/15
 */
PUBLIC void
int_dummy (void)
{

	(void) kprintf ("Unknown interrupt\n");

	return;
}

/**
 * @breif	init_idt
 * @author	kaworu
 * @date	since: 2003/11/15
 */
PUBLIC void
init_idt (void)
{
	register int		i;
	long			*p;
	const unsigned long	dpl = 0x8e00;

	p = idt_table;

	for (i = 0; i < IDT_TOTAL; i++)
	{
		*p = ( ( (long) __KERNEL_CS) << 16);
		*p++ |= (unsigned long) & int_dummy;
		*p++ = dpl;
	}

	r_idt.base	= (unsigned long) idt_table;
	r_idt.limit	= sizeof (idt_table);

	lidt (& r_idt);

	return;
}

