/** @file	idt.S
 *  @brief	setup idt
 *  Copyright (c) kaworu
 *  $Id: idt.S,v 1.2 2003/11/15 18:31:59 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2003/06/21 update: $Date: 2003/11/15 18:31:59 $
 *  @version	$Revision: 1.2 $
 */

/*
 * IDT: Interrupt Descriptor Table
 * IDT $B$N%5%$%:$O!"(B1$B$D$"$?$j(B 8byte $B$G$"$k!#(B
 * IDT $B$N%(%s%H%j$O(B 0 $B$+$i(B 255 $B$N9g7W(B256$B8D$G$"$k!#(B
 * IDT $B%F!<%V%k$N:GBg%5%$%:$O(B 8byte * 256 $B!a(B 2048byte
 * 
 * 
 * 
 * 
 */

	.code32
	.text
	.global		init_idt
/* this is dummy */
int_dummy:
	ret
init_idt:
	lea	int_dummy,	%ebx		// Load Effective Address
	lea	idt_table,	%edi		// Load Effective Address
	movl	(__KERNEL_CS << 16),%eax
	xorw	%bx,		%ax		// CS:int_dummy
	movw	$0x8e00,	%dx		// Interrupt gate DPL=0
	movw	$256,		%cx		// counter: 256
.1:
	movl	%eax,		(%edi)		// idt_table[0-ff][0]=&idt_dummy
	movl	%edx,		4(%edi)		// idt_table[0-ff][1]=0x8e00
	addl	$8,		%edi
	decw	%cx
	cmpw	$0,		%cx		// if(cx==0){CF=0;ZF=1;}
	jne	.1				// if(ZF==0)goto .1;
	ret

