/** @file	gdt.c
 *  @brief	gdt
 *  Copyright (c) kaworu
 *  $Id: gdt.c,v 1.1 2003/12/05 19:09:45 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2002/12/05 update: $Date: 2003/12/05 19:09:45 $
 *  @version	$Revision: 1.1 $
 */
asm (".code32");
#include "std.h"
#include "stdkern.h"
#include "boot.h"
#include "desc.h"

#define ATTR(sec) __attribute__( (section(#sec),aligned(1)))

#ifndef LINT
PUBLIC struct sdesc	gdt_table [ GDT_ENTRY_MIN ] ATTR(.data);
#else
PUBLIC struct sdesc	gdt_table [ GDT_ENTRY_MIN ];
#endif

struct rdesc	r_gdt;
/**
 * @breif	lgdt
 * @author	kaworu
 * @date	since: 2003/12/05
 */
PUBLIC void
lgdt (struct rdesc *gdtr)
{

	kprintf ("%s: %d\n", __func__, gdtr);

#if 1
	__asm__ volatile (
		"lgdt (%0)":
		/* no output */:
		"r" (gdtr)
		);
#endif

	return;
}

/**
 * @breif	gdt_set
 * @author	kaworu
 * @date	since: 2003/12/05
 */
PUBLIC void
get_set (struct sdesc *s, uint base, uint limit, uchar type, uchar dpl)
{

	s->lobase	= 0x00ffffff & base;
	s->hibase	= 0x0000ffff & (base >> 24);
	s->lolimit	= 0x0000ffff & limit;
	s->hilimit	= 0x0000000f & (limit >> 16);
	s->type		= type;
	s->dpl		= dpl;

	s->s		= 1;
	s->p		= 1;
	s->avl		= 0;
	s->res		= 0;
	s->db		= 0;
	s->g		= 1;

	return;
}

/**
 * @breif	gdt_init
 * @author	kaworu
 * @date	since: 2003/12/05
 */
PUBLIC void
gdt_init (void)
{
	register int		i;
	long			*p;
	const unsigned long	dpl = 0x8e00;


	return;
}
