/** @file	console.c
 *  @brief	console module
 *  Copyright (c) kaworu
 *  $Id: console.c,v 1.19 2003/12/01 17:03:07 kaworu Exp $
 *  @author	kaworu
 *  @date	since 2002/10/26 update: $Date: 2003/12/01 17:03:07 $
 *  @version	$Revision: 1.19 $
 */
asm (".code32");
#include "std.h"

/* console */
#define	CON_WIDTH	80
#define CON_HEIGHT	25
#define VRAM_ADDR	( (unsigned short *) 0xb8000 )

/**
 * Text Color
 */
#define TCOLOR_BLACK	0x0000
#define TCOLOR_RED	0x0100
#define TCOLOR_GREEN	0x0200
#define TCOLOR_YELLOW	0x0300
#define TCOLOR_BLUE	0x0400
#define TCOLOR_PINK	0x0500
#define TCOLOR_SKYBLUE	0x0600
#define TCOLOR_WHITE	0x0700

#define TCOLOR_GLAY	0x0800
#define TCOLOR_LRED	0x0900
#define TCOLOR_LGREEN	0x0a00
#define TCOLOR_LYELLOW	0x0b00
#define TCOLOR_LBLUE	0x0c00
#define TCOLOR_LPINK	0x0d00
#define TCOLOR_LSKYBLUE	0x0e00
#define TCOLOR_LWHITE	0x0f00

struct CONSOLE
{
	/* cursor position */
	unsigned short	x;
	unsigned short	y;
	unsigned short	max_x;
	unsigned short	max_y;
	word		fgcolor;
	word		bgcolor;
};

PRIVATE struct CONSOLE	console = {
#ifndef LINT
	.x		= 0,			/* not init */
	.y		= 0,			/* not init */
	.max_x		= CON_WIDTH,
	.max_y		= CON_HEIGHT,
	.fgcolor	= TCOLOR_WHITE,
	.bgcolor	= 0x0000
#else  /* LINT */
	0,			/* not init */
	0,			/* not init */
	CON_WIDTH,
	CON_HEIGHT,
	TCOLOR_WHITE,
	0x0000
#endif  /* LINT */
};

/**
 * @breif	console init
 * @author	kaworu
 * @date	since: 2003/11/0x
 */
void
con_init (void)
{
	byte	*cursor;

	cursor = (byte *) ( (0x0040 << 4L) + 0x0050);

	console.x	= 0;
	console.y	= 0;
	/* ΰ֤ȤƤʤȻפ */
	console.x	= *cursor;
	console.y	= *(cursor + 1);
	console.x	= 0;
	console.y	= 0;
	console.max_x	= CON_WIDTH;
	console.max_y	= CON_HEIGHT;
	console.fgcolor	= TCOLOR_WHITE;
	console.bgcolor	= 0x0000;

	return;
}

PRIVATE void
con_write (unsigned char x)
{
	word	*p = VRAM_ADDR;

	p += console.x + console.y * console.max_x;
	*p = (word) (console.fgcolor | x);

	return;
}

/* for test */
void
con_puts (char *ptr)
{
	char	*p;

	for (p = ptr; *p != '\0'; p++)
	{
		putc (*p);
	}

	return;
}

/**
 * @breif	scroll
 *		̤򥹥뤵
 * @author	kaworu
 * @date	since: 2003/11/17
 */
PRIVATE void
scroll (void)
{
	word		*p, *q;
	word		*limit;
	struct CONSOLE	*c;

	c = & console;
	p = VRAM_ADDR;
	q = p + c->max_x;

	limit = p + c->max_x * c->max_y;

	while (q < limit)
	{
		*p++ = *q++;
	}

	while (p < limit)
	{
		*p++ = ' ';
	}

	return;
}

/**
 * @breif	putc
 * @author	kaworu
 * @date	since: 2003/11/17
 * @param	c [in]
 * @return	character value printed screen
 */
int
putc (int c)
{
	struct CONSOLE	*p;

	p = & console;

	if (c == '\n')
	{
		p->x = 0;
		p->y++;
		if (p->y == p->max_y - 1)
		{
			p->y--;
			scroll ();
		}
	}
	else if (c == '\r')
	{
		p->x = 0;
	}
	else if (c == '\b')
	{
		if (p->x == 0)
		{
			/* nothing */
		}
		else
		{
			p->x--;
			con_write (' ');
		}
	}
	else
	{
		con_write ((uchar) c);
		p->x++;
		if (p->x == p->max_x)
		{
			p->x = 0;
			p->y++;
			if (p->y == p->max_y)
			{
				scroll ();
				p->y--;
			}
		}
	}

	return (0);
}

/**
 * @breif	con_printi for debug
 *		ͤϹθƤʤ
 * @author	kaworu
 * @date	since: 2003/11/19
 * @param	c [in]
 * @return	character value printed screen
 */

#define ONLYBASE10

void
#ifdef ONLYBASE10
con_printi (int val)
#else
con_printi (int val, int base)
#endif
{
	int	setcursor (void);
	int	x;
	char	*p, *q;
	//char	num[16];// = "0123456789abcdef";
	char	*num = "0123456789abcdef";
	static char	s[8];//__attribute__( (sectinon(".data"),aligned(1)));
#ifdef ONLYBASE10
	int	base = 10;
#endif
#if 0
	num[0] = '0';
	num[1] = '1';
	num[2] = '2';
	num[3] = '3';
	num[4] = '4';
	num[5] = '5';
	num[6] = '6';
	num[7] = '7';
	num[8] = '8';
	num[9] = '9';
	num[10] = 'a';
	num[11] = 'b';
	num[12] = 'c';
	num[13] = 'd';
	num[14] = 'e';
	num[15] = 'f';
#endif
	/* integer to ascii */
#if 0				/* not buffering */
	if (val == base)
	{
		putc (0 + '1');
		putc (0 + '0');
		return;
	}
	for (q = s; val > base; )
	{
		x = val % base;
		//*q++ = "0123456789"[x];
		putc (x / base + '0');
		val /= base;
	}
	if (val == base)
	{
		putc (0 + '0');
		putc (1 + '0');
	}
	else
	{
		putc (val + '0');
	}
#else
#if 1				/* buffering */
	for (q = s; val >= base; )
	{
		*q++ = num [val % base];
		val /= base;
	}
#else
	q = s;
	do
	{
		*q++ = "0123456789abcdef" [val % base];
	}
	while (val /= base);
#endif
	*q = num [val];
	*(q + 1) = '\0';

	for (p = s; p < q; )
	{
		x = *p;
		*p++ = *q;
		*q-- = (char) x;
	}

	for(p = s; *p; p++)
	{
		putc ( *p );
	}
	//con_puts (s);
	setcursor ();
#endif
	return;
}

/**
 * @breif	setcursor
 * @author	kaworu
 * @date	since: 2003/11/20
 */
int
setcursor (void)
{

	/* nothing */
	/* this is dummy now */

	return (0);
}
