//
// UnicodeConverter.h
//
// $Id: //poco/1.4/Foundation/include/Poco/UnicodeConverter.h#1 $
//
// Library: Foundation
// Package: Text
// Module:  UnicodeConverter
//
// Definition of the UnicodeConverter class.
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Foundation_UnicodeConverter_INCLUDED
#define Foundation_UnicodeConverter_INCLUDED


#include "Poco/Foundation.h"
#include "Poco/UTFString.h"


namespace Poco {


class Foundation_API UnicodeConverter
	/// A convenience class that converts strings from
	/// UTF-8 encoded std::strings to UTF-16 or UTF-32 encoded std::wstrings
	/// and vice-versa.
	///
	/// This class is mainly used for working with the Unicode Windows APIs
	/// and probably won't be of much use anywhere else ???
{
public:
	static void convert(const std::string& utf8String, UTF32String& utf32String);
		/// Converts the given UTF-8 encoded string into an UTF-32 encoded wide string.

	static void convert(const char* utf8String,  std::size_t length, UTF32String& utf32String);
		/// Converts the given UTF-8 encoded character sequence into an UTF-32 encoded wide string.

	static void convert(const char* utf8String, UTF32String& utf32String);
		/// Converts the given zero-terminated UTF-8 encoded character sequence into an UTF-32 encoded wide string.

	static void convert(const std::string& utf8String, UTF16String& utf16String);
		/// Converts the given UTF-8 encoded string into an UTF-16 encoded wide string.

	static void convert(const char* utf8String,  std::size_t length, UTF16String& utf16String);	
		/// Converts the given UTF-8 encoded character sequence into an UTF-16 encoded wide string.

	static void convert(const char* utf8String, UTF16String& utf16String);	
		/// Converts the given zero-terminated UTF-8 encoded character sequence into an UTF-16 encoded wide string.

	static void convert(const UTF16String& utf16String, std::string& utf8String);
		/// Converts the given UTF-16 encoded wide string into an UTF-8 encoded string.

	static void convert(const UTF32String& utf32String, std::string& utf8String);
		/// Converts the given UTF-32 encoded wide string into an UTF-8 encoded string.

	static void convert(const UTF16Char* utf16String,  std::size_t length, std::string& utf8String);
		/// Converts the given zero-terminated UTF-16 encoded wide character sequence into an UTF-8 encoded string.

	static void convert(const UTF32Char* utf16String, std::size_t length, std::string& utf8String);
		/// Converts the given zero-terminated UTF-32 encoded wide character sequence into an UTF-8 encoded string.

	static void convert(const UTF16Char* utf16String, std::string& utf8String);
		/// Converts the given UTF-16 encoded zero terminated character sequence into an UTF-8 encoded string.

	static void convert(const UTF32Char* utf32String, std::string& utf8String);
		/// Converts the given UTF-32 encoded zero terminated character sequence into an UTF-8 encoded string.

	template <typename F, typename T>
	static void toUTF32(const F& f, T& t)
	{
		convert(f, t);
	}

	template <typename F, typename T>
	static void toUTF32(const F& f, std::size_t l, T& t)
	{
		convert(f, l, t);
	}

	template <typename F, typename T>
	static void toUTF16(const F& f, T& t)
	{
		convert(f, t);
	}

	template <typename F, typename T>
	static void toUTF16(const F& f, std::size_t l, T& t)
	{
		convert(f, l, t);
	}

	template <typename F, typename T>
	static void toUTF8(const F& f, T& t)
	{
		convert(f, t);
	}

	template <typename F, typename T>
	static void toUTF8(const F& f, std::size_t l, T& t)
	{
		convert(f, l, t);
	}

	template <typename T>
	static size_t UTFStrlen(const T* ptr)
		/// Returns the length (in characters) of a zero-terminated UTF string.
	{
		if (ptr == 0) return 0;
		const T* p;
		for (p = ptr; *p; ++p);
		return p - ptr;
	}
};


} // namespace Poco


#endif // Foundation_UnicodeConverter_INCLUDED
