//
// SortedDirectoryIterator.h
//
// $Id$
//
// Library: Foundation
// Package: Filesystem
// Module:  DirectoryIterator
//
// Definition of the SortedDirectoryIterator class.
//
// Copyright (c) 2004-2012, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
//
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Foundation_SortedDirectoryIterator_INCLUDED
#define Foundation_SortedDirectoryIterator_INCLUDED

#include "Poco/Foundation.h"
#include "Poco/File.h"
#include "Poco/Path.h"
#include "Poco/DirectoryIterator.h"
#include <deque>


namespace Poco
{

class Foundation_API SortedDirectoryIterator: public DirectoryIterator
	/// The SortedDirectoryIterator class is similar to
	/// DirectoryIterator class, but places directories before files
	/// and sorts content alphabetically.
{
public:
	SortedDirectoryIterator();
		/// Creates the end iterator.

	SortedDirectoryIterator(const std::string& path);
		/// Creates a directory iterator for the given path.

	SortedDirectoryIterator(const DirectoryIterator& iterator);
		/// Creates a directory iterator for the given path.

	SortedDirectoryIterator(const File& file);
		/// Creates a directory iterator for the given file.

	SortedDirectoryIterator(const Path& path);
		/// Creates a directory iterator for the given path.

	virtual ~SortedDirectoryIterator();
		/// Destroys the DirsFirstDirectoryIterator.

	virtual SortedDirectoryIterator& operator ++();   // prefix

private:
	bool _is_finished;
	std::deque<std::string> _directories;
	std::deque<std::string> _files;

	void next();
		/// Take next item
	void scan();
		/// Scan directory to collect its children directories and files
};


} // namespace Poco

#endif //Foundation_SortedDirectoryIterator_INCLUDED
