//
// PartStore.h
//
// $Id: //poco/1.4/Net/include/Poco/Net/PartStore.h#1 $
//
// Library: Net
// Package: Messages
// Module:  PartStore
//
// Definition of the PartStore class.
//
// Copyright (c) 2005-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef Net_PartStore_INCLUDED
#define Net_PartStore_INCLUDED


#include "Poco/Net/Net.h"
#include "Poco/Net/PartSource.h"
#include "Poco/FileStream.h"


namespace Poco {
namespace Net {


class Net_API PartStore: public PartSource
	/// A parent class for part stores storing message parts.
{
public:
	PartStore(const std::string& mediaType);
		/// Creates the PartStore for the given MIME type.

	~PartStore();
		/// Destroys the PartFileStore.

private:
	PartStore();
};


class Net_API FilePartStore: public PartStore
	/// An implementation of PartSource for persisting
	/// parts (usually email attachment files) to the file system.
{
public:
	FilePartStore(const std::string& content, const std::string& mediaType, const std::string& filename = "");
		/// Creates the FilePartStore for the given MIME type.
		/// For security purposes, attachment filename is NOT used to save file to the file system.
		/// A unique temporary file name is used to persist the file.
		/// The given filename parameter is the message part (attachment) filename (see filename()) only.
		///
		/// Throws an exception if the file cannot be opened.

	~FilePartStore();
		/// Destroys the FilePartStore.

	std::istream& stream();
		/// Returns a file input stream for the given file.

	const std::string& filename() const;
		/// Returns the filename portion of the path.
		/// This is the name under which the file is known
		/// to the user of this class (typically, MailMessage
		/// class). The real name of the file as saved
		/// to the filesystem can be obtained by calling
		/// path() member function.

	const std::string& path() const;
		/// Returns the full path to the file as saved
		/// to the file system. For security reasons,
		/// file is not saved under the real file name
		/// (as specified by the user).

private:
	std::string      _filename;
	std::string      _path;
	Poco::FileStream _fstr;
};


class PartStoreFactory
	/// Parent factory class for part stores creation.
{
public:
	virtual PartSource* createPartStore(const std::string& content, const std::string& mediaType, const std::string& filename = "") = 0;
};


class FilePartStoreFactory: public PartStoreFactory
{
public:
	PartSource* createPartStore(const std::string& content, const std::string& mediaType, const std::string& filename = "")
	{
		return new FilePartStore(content, mediaType, filename);
	}
};


} } // namespace Poco::Net


#endif // Net_PartStore_INCLUDED
